/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.LimitObjectInput;
import org.apache.derby.iapi.store.raw.Compensation;
import org.apache.derby.iapi.store.raw.ContainerKey;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.store.raw.Undoable;
import org.apache.derby.iapi.store.raw.data.RawContainerHandle;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.iapi.store.raw.xact.RawTransaction;
import org.apache.derby.iapi.util.ByteArray;
import org.apache.derby.impl.store.raw.data.BaseDataFileFactory;
import org.apache.derby.impl.store.raw.data.EncryptContainerUndoOperation;
import org.apache.derby.impl.store.raw.data.EncryptOrDecryptData;

public class EncryptContainerOperation
implements Undoable {
    private ContainerKey containerId;

    protected EncryptContainerOperation(RawContainerHandle rawContainerHandle) throws StandardException {
        this.containerId = rawContainerHandle.getId();
    }

    public EncryptContainerOperation() {
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        this.containerId.writeExternal(objectOutput);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.containerId = ContainerKey.read(objectInput);
    }

    public ByteArray getPreparedLog() {
        return null;
    }

    public void releaseResource(Transaction transaction) {
    }

    public int group() {
        return 256;
    }

    public boolean needsRedo(Transaction transaction) throws StandardException {
        return false;
    }

    public int getTypeFormatId() {
        return 459;
    }

    public final void doMe(Transaction transaction, LogInstant logInstant, LimitObjectInput limitObjectInput) throws StandardException {
        this.releaseResource(transaction);
    }

    public void undoMe(Transaction transaction) throws StandardException {
        BaseDataFileFactory baseDataFileFactory = (BaseDataFileFactory)((RawTransaction)transaction).getDataFactory();
        EncryptOrDecryptData encryptOrDecryptData = new EncryptOrDecryptData(baseDataFileFactory);
        encryptOrDecryptData.restoreContainer(this.containerId);
        this.releaseResource(transaction);
    }

    public Compensation generateUndo(Transaction transaction, LimitObjectInput limitObjectInput) throws StandardException {
        return new EncryptContainerUndoOperation(this);
    }

    public String toString() {
        return null;
    }
}

