/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.gml.xml.v321;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.geotoolkit.gml.xml.AbstractGeometry;
import org.geotoolkit.gml.xml.v321.AbstractGMLType;
import org.geotoolkit.gml.xml.v321.AbstractGeometricAggregateType;
import org.geotoolkit.gml.xml.v321.AbstractGeometricPrimitiveType;
import org.geotoolkit.gml.xml.v321.GeometricComplexType;
import org.geotoolkit.gml.xml.v321.GridType;
import org.geotoolkit.referencing.CRS;
import org.geotoolkit.util.ComparisonMode;
import org.geotoolkit.util.Utilities;
import org.opengis.filter.expression.Expression;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.Geometry;
import org.opengis.geometry.Precision;
import org.opengis.geometry.TransfiniteSet;
import org.opengis.geometry.complex.Complex;
import org.opengis.geometry.primitive.PrimitiveBoundary;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="AbstractGeometryType")
@XmlSeeAlso(value={GeometricComplexType.class, GridType.class, AbstractGeometricPrimitiveType.class, AbstractGeometricAggregateType.class})
public abstract class AbstractGeometryType
extends AbstractGMLType
implements Geometry,
Expression,
AbstractGeometry {
    @XmlAttribute
    @XmlSchemaType(name="anyURI")
    private String srsName;
    @XmlAttribute
    @XmlSchemaType(name="positiveInteger")
    private Integer srsDimension;
    @XmlAttribute
    private List<String> axisLabels;
    @XmlAttribute
    private List<String> uomLabels;
    @XmlTransient
    private Precision precision;

    AbstractGeometryType() {
    }

    public AbstractGeometryType(Integer srsDimension, String srsName, List<String> axisLabels, List<String> uomLabels) {
        this.axisLabels = axisLabels;
        this.srsDimension = srsDimension;
        this.srsName = srsName;
        this.uomLabels = uomLabels;
    }

    public AbstractGeometryType(String srsName) {
        this.srsName = srsName;
    }

    public AbstractGeometryType(String id, String srsName) {
        super(id);
        this.srsName = srsName;
    }

    @Override
    public String getSrsName() {
        return this.srsName;
    }

    @Override
    public void setSrsName(String value) {
        this.srsName = value;
    }

    public Integer getSrsDimension() {
        return this.srsDimension;
    }

    public void setSrsDimension(Integer value) {
        this.srsDimension = value;
    }

    public List<String> getAxisLabels() {
        if (this.axisLabels == null) {
            this.axisLabels = new ArrayList<String>();
        }
        return this.axisLabels;
    }

    public List<String> getUomLabels() {
        if (this.uomLabels == null) {
            this.uomLabels = new ArrayList<String>();
        }
        return this.uomLabels;
    }

    @Override
    public PrimitiveBoundary getBoundary() {
        return null;
    }

    @Override
    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        if (this.srsName != null) {
            try {
                return CRS.decode(this.srsName);
            }
            catch (FactoryException ex) {
                Logger.getLogger(org.geotoolkit.gml.xml.v311.AbstractGeometryType.class.getName()).log(Level.WARNING, "Could not decode CRS which name is : " + this.srsName, ex);
            }
        }
        return null;
    }

    @Override
    public Precision getPrecision() {
        return this.precision;
    }

    public void setPrecision(Precision precision) {
        this.precision = precision;
    }

    @Override
    public Geometry getMbRegion() {
        return null;
    }

    @Override
    public DirectPosition getRepresentativePoint() {
        return null;
    }

    @Override
    public Complex getClosure() {
        return null;
    }

    @Override
    public boolean isSimple() {
        return false;
    }

    @Override
    public boolean isCycle() {
        return false;
    }

    @Override
    public double distance(Geometry geometry) {
        return -1.0;
    }

    @Override
    public int getDimension(DirectPosition point) {
        return -1;
    }

    @Override
    public int getCoordinateDimension() {
        Integer bi = this.getSrsDimension();
        if (bi == null) {
            return 2;
        }
        return bi;
    }

    @Override
    public Set<? extends Complex> getMaximalComplex() {
        return new HashSet();
    }

    @Override
    public Geometry transform(CoordinateReferenceSystem newCRS) throws TransformException {
        return null;
    }

    @Override
    public Geometry transform(CoordinateReferenceSystem newCRS, MathTransform transform) throws TransformException {
        return null;
    }

    @Override
    public Envelope getEnvelope() {
        return null;
    }

    @Override
    public DirectPosition getCentroid() {
        return null;
    }

    @Override
    public Geometry getConvexHull() {
        return null;
    }

    @Override
    public Geometry getBuffer(double distance) {
        return null;
    }

    @Override
    public boolean isMutable() {
        return true;
    }

    @Override
    public Geometry toImmutable() {
        return null;
    }

    @Override
    public boolean contains(TransfiniteSet pointSet) {
        return false;
    }

    @Override
    public boolean contains(DirectPosition point) {
        return false;
    }

    @Override
    public boolean intersects(TransfiniteSet pointSet) {
        return false;
    }

    @Override
    public boolean equals(TransfiniteSet pointSet) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public TransfiniteSet union(TransfiniteSet pointSet) {
        return null;
    }

    @Override
    public TransfiniteSet intersection(TransfiniteSet pointSet) {
        return null;
    }

    @Override
    public TransfiniteSet difference(TransfiniteSet pointSet) {
        return null;
    }

    @Override
    public TransfiniteSet symmetricDifference(TransfiniteSet pointSet) {
        return null;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean equals(Object object, ComparisonMode mode) {
        if (object != null && this.getClass().equals(object.getClass())) {
            AbstractGeometryType that = (AbstractGeometryType)object;
            return Utilities.equals(this.axisLabels, that.axisLabels) && Utilities.equals(this.srsDimension, that.srsDimension) && Utilities.equals(this.srsName, that.srsName) && Utilities.equals(this.uomLabels, that.uomLabels);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 37 * hash + (this.srsDimension != null ? this.srsDimension.hashCode() : 0);
        hash = 37 * hash + (this.srsName != null ? this.srsName.hashCode() : 0);
        hash = 37 * hash + (this.axisLabels != null ? ((Object)this.axisLabels).hashCode() : 0);
        hash = 37 * hash + (this.uomLabels != null ? ((Object)this.uomLabels).hashCode() : 0);
        return hash;
    }

    @Override
    public AbstractGeometryType clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }
}

