/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.math;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.RandomAccess;
import org.geotoolkit.math.ArrayVector;
import org.geotoolkit.math.ConcatenatedVector;
import org.geotoolkit.math.SequenceVector;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.ArgumentChecks;
import org.geotoolkit.util.collection.CheckedCollection;
import org.geotoolkit.util.collection.WeakHashSet;
import org.geotoolkit.util.converter.Numbers;

public abstract class Vector
extends AbstractList<Number>
implements CheckedCollection<Number>,
RandomAccess {
    private static final WeakHashSet<int[]> INDICES = WeakHashSet.newInstance(int[].class);

    public static Vector create(Object object) throws IllegalArgumentException {
        if (object == null || object instanceof Vector) {
            return (Vector)object;
        }
        if (object instanceof double[]) {
            return new ArrayVector.Double((double[])object);
        }
        if (object instanceof float[]) {
            return new ArrayVector.Float((float[])object);
        }
        Class<?> clazz = object.getClass();
        Class<?> clazz2 = clazz.getComponentType();
        if (clazz2 != null && Number.class.isAssignableFrom(clazz2 = Numbers.primitiveToWrapper(clazz2))) {
            return new ArrayVector(object);
        }
        throw new IllegalArgumentException(Errors.format(226, clazz2 != null ? clazz2 : clazz));
    }

    public static Vector createSequence(double d, double d2, int n) {
        return new SequenceVector(d, d2, n);
    }

    protected Vector() {
    }

    @Override
    public abstract int size();

    @Override
    public abstract Class<? extends Number> getElementType();

    public abstract boolean isNaN(int var1) throws IndexOutOfBoundsException;

    public abstract double doubleValue(int var1) throws IndexOutOfBoundsException, ClassCastException;

    public abstract float floatValue(int var1) throws IndexOutOfBoundsException, ClassCastException;

    public abstract long longValue(int var1) throws IndexOutOfBoundsException, ClassCastException;

    public abstract int intValue(int var1) throws IndexOutOfBoundsException, ClassCastException;

    public abstract short shortValue(int var1) throws IndexOutOfBoundsException, ClassCastException;

    public abstract byte byteValue(int var1) throws IndexOutOfBoundsException, ClassCastException;

    @Override
    public abstract Number get(int var1) throws IndexOutOfBoundsException;

    @Override
    public abstract Number set(int var1, Number var2) throws IndexOutOfBoundsException, ArrayStoreException;

    Vector backingVector() {
        return this;
    }

    int[] toBacking(int[] nArray) throws IndexOutOfBoundsException {
        nArray = (int[])nArray.clone();
        int n = this.size();
        for (int n2 : nArray) {
            ArgumentChecks.ensureValidIndex(n, n2);
        }
        return nArray;
    }

    public Vector view(int ... nArray) throws IndexOutOfBoundsException {
        int n;
        int n2;
        nArray = this.toBacking(nArray);
        switch (nArray.length) {
            case 0: {
                n2 = 0;
                n = 1;
                break;
            }
            case 1: {
                n2 = nArray[0];
                n = 1;
                break;
            }
            default: {
                n2 = nArray[0];
                int n3 = nArray[1];
                n = n3 - n2;
                for (int i = 2; i < nArray.length; ++i) {
                    int n4 = nArray[i];
                    if (n4 - n3 != n) {
                        Vector vector = this.backingVector();
                        vector.getClass();
                        return vector.new View(INDICES.unique(nArray));
                    }
                    n3 = n4;
                }
            }
        }
        return this.subList(n2, n, nArray.length);
    }

    public final Vector reverse() {
        int n = this.size();
        return n != 0 ? this.subList(n - 1, -1, n) : this;
    }

    public final Vector subList(int n, int n2) throws IndexOutOfBoundsException {
        return this.subList(n, 1, n2 - n);
    }

    public Vector subList(int n, int n2, int n3) throws IndexOutOfBoundsException {
        if (n2 == 1 && n == 0 && n3 == this.size()) {
            return this;
        }
        return this.createSubList(n, n2, n3);
    }

    Vector createSubList(int n, int n2, int n3) {
        return new SubList(n, n2, n3);
    }

    public Vector concatenate(Vector vector) {
        if (vector.isEmpty()) {
            return this;
        }
        if (this.isEmpty()) {
            return vector;
        }
        return this.createConcatenate(vector);
    }

    Vector createConcatenate(Vector vector) {
        return new ConcatenatedVector(this, vector);
    }

    static void ensureValid(int n, int n2, int n3) {
        if (n3 < 0) {
            Object object;
            Object object2;
            int n4;
            if (n2 == 1) {
                n4 = 14;
                object2 = n;
                object = n + n3;
            } else {
                n4 = 73;
                object2 = "range";
                object = "[" + n + ':' + n2 + ':' + (n + n2 * n3) + ']';
            }
            throw new IllegalArgumentException(Errors.format(n4, object2, object));
        }
    }

    private final class SubList
    extends Vector
    implements Serializable {
        private static final long serialVersionUID = 7641036842053528486L;
        private final int first;
        private final int step;
        private final int length;

        protected SubList(int n, int n2, int n3) {
            SubList.ensureValid(n, n2, n3);
            this.first = n;
            this.step = n2;
            this.length = n3;
        }

        @Override
        Vector backingVector() {
            return Vector.this;
        }

        private int toBacking(int n) throws IndexOutOfBoundsException {
            ArgumentChecks.ensureValidIndex(this.length, n);
            return n * this.step + this.first;
        }

        @Override
        int[] toBacking(int[] nArray) throws IndexOutOfBoundsException {
            int[] nArray2 = new int[nArray.length];
            for (int i = 0; i < nArray2.length; ++i) {
                nArray2[i] = this.toBacking(nArray[i]);
            }
            return nArray2;
        }

        @Override
        public Class<? extends Number> getElementType() {
            return Vector.this.getElementType();
        }

        @Override
        public int size() {
            return this.length;
        }

        @Override
        public boolean isNaN(int n) {
            return Vector.this.isNaN(this.toBacking(n));
        }

        @Override
        public double doubleValue(int n) {
            return Vector.this.doubleValue(this.toBacking(n));
        }

        @Override
        public float floatValue(int n) {
            return Vector.this.floatValue(this.toBacking(n));
        }

        @Override
        public long longValue(int n) {
            return Vector.this.longValue(this.toBacking(n));
        }

        @Override
        public int intValue(int n) {
            return Vector.this.intValue(this.toBacking(n));
        }

        @Override
        public short shortValue(int n) {
            return Vector.this.shortValue(this.toBacking(n));
        }

        @Override
        public byte byteValue(int n) {
            return Vector.this.byteValue(this.toBacking(n));
        }

        @Override
        public Number get(int n) {
            return Vector.this.get(this.toBacking(n));
        }

        @Override
        public Number set(int n, Number number) {
            return Vector.this.set(this.toBacking(n), number);
        }

        @Override
        Vector createSubList(int n, int n2, int n3) {
            n = this.toBacking(n);
            return Vector.this.subList(n, n2 *= this.step, n3);
        }

        @Override
        Vector createConcatenate(Vector vector) {
            if (vector instanceof SubList && vector.backingVector() == Vector.this) {
                SubList subList = (SubList)vector;
                if (subList.step == this.step && subList.first == this.first + this.step * this.length) {
                    return Vector.this.createSubList(this.first, this.step, this.length + subList.length);
                }
            }
            return super.createConcatenate(vector);
        }
    }

    private final class View
    extends Vector
    implements Serializable {
        private static final long serialVersionUID = 6574040261355090760L;
        private final int[] index;

        public View(int[] nArray) {
            this.index = nArray;
        }

        @Override
        Vector backingVector() {
            return Vector.this;
        }

        @Override
        int[] toBacking(int[] nArray) throws IndexOutOfBoundsException {
            int[] nArray2 = new int[nArray.length];
            for (int i = 0; i < nArray2.length; ++i) {
                nArray2[i] = this.index[nArray[i]];
            }
            return nArray2;
        }

        @Override
        public Class<? extends Number> getElementType() {
            return Vector.this.getElementType();
        }

        @Override
        public int size() {
            return this.index.length;
        }

        @Override
        public boolean isNaN(int n) {
            return Vector.this.isNaN(this.index[n]);
        }

        @Override
        public double doubleValue(int n) {
            return Vector.this.doubleValue(this.index[n]);
        }

        @Override
        public float floatValue(int n) {
            return Vector.this.floatValue(this.index[n]);
        }

        @Override
        public long longValue(int n) {
            return Vector.this.longValue(this.index[n]);
        }

        @Override
        public int intValue(int n) {
            return Vector.this.intValue(this.index[n]);
        }

        @Override
        public short shortValue(int n) {
            return Vector.this.shortValue(this.index[n]);
        }

        @Override
        public byte byteValue(int n) {
            return Vector.this.byteValue(this.index[n]);
        }

        @Override
        public Number get(int n) {
            return Vector.this.get(this.index[n]);
        }

        @Override
        public Number set(int n, Number number) {
            return Vector.this.set(this.index[n], number);
        }

        @Override
        Vector createSubList(int n, int n2, int n3) {
            View.ensureValid(n, n2, n3);
            int[] nArray = new int[n3];
            if (n2 == 1) {
                System.arraycopy(this.index, n, nArray, 0, n3);
            } else {
                for (int i = 0; i < n3; ++i) {
                    nArray[i] = this.index[n];
                    n += n2;
                }
            }
            return Vector.this.view(nArray);
        }

        @Override
        Vector createConcatenate(Vector vector) {
            if (vector instanceof View && vector.backingVector() == Vector.this) {
                int[] nArray = ((View)vector).index;
                int[] nArray2 = Arrays.copyOf(this.index, this.index.length + nArray.length);
                System.arraycopy(nArray, 0, nArray2, this.index.length, nArray.length);
                return Vector.this.view(nArray2);
            }
            return super.createConcatenate(vector);
        }
    }
}

