/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.metadata;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Set;
import net.jcip.annotations.Immutable;
import org.geotoolkit.lang.ValueRange;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.NumberRange;
import org.geotoolkit.util.Utilities;
import org.geotoolkit.util.collection.WeakHashSet;
import org.geotoolkit.util.converter.Classes;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.UML;

@Immutable
public class ValueRestriction
implements Serializable {
    private static final long serialVersionUID = 888961503200860655L;
    static final ValueRestriction PENDING = new ValueRestriction(null, null, null);
    private static final WeakHashSet<ValueRestriction> POOL = WeakHashSet.newInstance(ValueRestriction.class);
    public final Obligation obligation;
    public final NumberRange<?> range;
    public final Set<?> validValues;

    protected ValueRestriction(Obligation obligation, NumberRange<?> numberRange, Set<?> set) {
        this.obligation = obligation;
        this.range = numberRange;
        this.validValues = set;
    }

    static ValueRestriction create(Obligation obligation, NumberRange<?> numberRange, Set<?> set) {
        if (numberRange == null && set == null && obligation != Obligation.MANDATORY && obligation != Obligation.FORBIDDEN) {
            return null;
        }
        return POOL.unique(new ValueRestriction(obligation, numberRange, set));
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static ValueRestriction create(Class<?> clazz, Method method, Method method2) {
        Obligation obligation = null;
        NumberRange numberRange = null;
        UML uML = method.getAnnotation(UML.class);
        while (true) {
            ValueRange valueRange;
            if (uML != null) {
                obligation = uML.obligation();
            }
            if ((valueRange = method.getAnnotation(ValueRange.class)) != null) {
                void var7_9;
                Class<Number> clazz2 = Number.class;
                if (!Number.class.isAssignableFrom(clazz)) throw new ClassCastException(Errors.format(76, clazz, var7_9));
                Class<Comparable> clazz3 = Comparable.class;
                if (!Comparable.class.isAssignableFrom(clazz)) throw new ClassCastException(Errors.format(76, clazz, var7_9));
                numberRange = new NumberRange(clazz, valueRange);
            }
            if (method == method2) return ValueRestriction.create(obligation, numberRange, null);
            method = method2;
        }
    }

    final ValueRestriction violation(Object object) {
        Obligation obligation = this.obligation;
        NumberRange<?> numberRange = this.range;
        Set<?> set = this.validValues;
        boolean bl = false;
        if (obligation != (object == null ? Obligation.MANDATORY : Obligation.FORBIDDEN)) {
            obligation = null;
            bl = true;
        }
        if (object == null || numberRange == null || object instanceof Number && numberRange.contains((Number)object)) {
            numberRange = null;
            bl = true;
        }
        if (object == null || set == null || set.contains(object)) {
            set = null;
            bl = true;
        }
        return bl ? ValueRestriction.create(obligation, numberRange, set) : this;
    }

    public boolean equals(Object object) {
        if (object != null && object.getClass() == this.getClass()) {
            ValueRestriction valueRestriction = (ValueRestriction)object;
            return this.obligation == valueRestriction.obligation && Utilities.equals(this.range, valueRestriction.range) && Utilities.equals(this.validValues, valueRestriction.validValues);
        }
        return false;
    }

    public int hashCode() {
        int n = -112666129;
        if (this.obligation != null) {
            n ^= this.obligation.hashCode();
        }
        if (this.range != null) {
            n ^= this.range.hashCode();
        }
        if (this.validValues != null) {
            n ^= ((Object)this.validValues).hashCode();
        }
        return n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(Classes.getShortClassName(this)).append('[');
        String string = "";
        if (this.obligation != null) {
            stringBuilder.append(this.obligation.name());
            string = ", ";
        }
        if (this.range != null) {
            stringBuilder.append(string).append("range=").append(this.range);
            string = ", ";
        }
        if (this.validValues != null) {
            stringBuilder.append(string).append("validValues=").append(this.validValues);
        }
        return stringBuilder.append(']').toString();
    }
}

