/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.metadata.iso.spatial;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.geotoolkit.lang.Static;
import org.geotoolkit.referencing.operation.MathTransforms;
import org.geotoolkit.referencing.operation.matrix.Matrices;
import org.geotoolkit.referencing.operation.matrix.XMatrix;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.Utilities;
import org.opengis.metadata.spatial.PixelOrientation;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;

public final class PixelTranslation
extends Static
implements Serializable {
    private static final long serialVersionUID = 2616596940766158984L;
    private static final MathTransform[] translations = new MathTransform[16];
    public final PixelOrientation orientation;
    public final double dx;
    public final double dy;
    private static final Map<PixelOrientation, PixelTranslation> ORIENTATIONS = new HashMap<PixelOrientation, PixelTranslation>(12);

    private PixelTranslation(PixelOrientation pixelOrientation, double d, double d2) {
        this.orientation = pixelOrientation;
        this.dx = d;
        this.dy = d2;
        if (ORIENTATIONS.put(pixelOrientation, this) != null) {
            throw new AssertionError(this);
        }
    }

    private PixelTranslation(String string, double d, double d2) {
        this(PixelOrientation.valueOf(string), d, d2);
    }

    public static PixelOrientation getPixelOrientation(PixelInCell pixelInCell) throws IllegalArgumentException {
        if (pixelInCell == null) {
            return null;
        }
        if (pixelInCell.equals(PixelInCell.CELL_CENTER)) {
            return PixelOrientation.CENTER;
        }
        if (pixelInCell.equals(PixelInCell.CELL_CORNER)) {
            return PixelOrientation.UPPER_LEFT;
        }
        throw new IllegalArgumentException(Errors.format(73, "anchor", pixelInCell));
    }

    public static double getPixelTranslation(PixelInCell pixelInCell) {
        if (PixelInCell.CELL_CENTER.equals(pixelInCell)) {
            return 0.0;
        }
        if (PixelInCell.CELL_CORNER.equals(pixelInCell)) {
            return -0.5;
        }
        throw new IllegalArgumentException(Errors.format(73, "anchor", pixelInCell));
    }

    public static PixelTranslation getPixelTranslation(PixelOrientation pixelOrientation) throws IllegalArgumentException {
        PixelTranslation pixelTranslation = ORIENTATIONS.get(pixelOrientation);
        if (pixelTranslation == null) {
            throw new IllegalArgumentException(Errors.format(73, "anchor", pixelOrientation));
        }
        return pixelTranslation;
    }

    public static PixelOrientation getPixelOrientation(double d, double d2) {
        for (PixelTranslation pixelTranslation : ORIENTATIONS.values()) {
            if (pixelTranslation.dx != d || pixelTranslation.dy != d2) continue;
            return pixelTranslation.orientation;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MathTransform translate(MathTransform mathTransform, PixelInCell pixelInCell, PixelInCell pixelInCell2) {
        MathTransform mathTransform2;
        if (Utilities.equals(pixelInCell, pixelInCell2)) {
            return mathTransform;
        }
        if (mathTransform == null) {
            return null;
        }
        int n = mathTransform.getSourceDimensions();
        double d = PixelTranslation.getPixelTranslation(pixelInCell2) - PixelTranslation.getPixelTranslation(pixelInCell);
        int n2 = d == -0.5 ? 2 * n : (d == 0.5 ? 2 * n + 1 : translations.length);
        if (n2 >= translations.length) {
            mathTransform2 = MathTransforms.linear(n, 1.0, d);
            return MathTransforms.concatenate(mathTransform2, mathTransform);
        }
        MathTransform[] mathTransformArray = translations;
        synchronized (translations) {
            mathTransform2 = translations[n2];
            if (mathTransform2 != null) return MathTransforms.concatenate(mathTransform2, mathTransform);
            mathTransform2 = MathTransforms.linear(n, 1.0, d);
            PixelTranslation.translations[n2] = mathTransform2;
            // ** MonitorExit[var8_7] (shouldn't be in output)
            return MathTransforms.concatenate(mathTransform2, mathTransform);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MathTransform translate(MathTransform mathTransform, PixelOrientation pixelOrientation, PixelOrientation pixelOrientation2, int n, int n2) {
        MathTransform mathTransform2;
        if (Utilities.equals(pixelOrientation, pixelOrientation2)) {
            return mathTransform;
        }
        if (mathTransform == null) {
            return null;
        }
        int n3 = mathTransform.getSourceDimensions();
        if (n < 0 || n >= n3) {
            throw PixelTranslation.illegalDimension("xDimension", n);
        }
        if (n2 < 0 || n2 >= n3) {
            throw PixelTranslation.illegalDimension("yDimension", n2);
        }
        if (n == n2) {
            throw PixelTranslation.illegalDimension("xDimension", "yDimension");
        }
        PixelTranslation pixelTranslation = PixelTranslation.getPixelTranslation(pixelOrientation);
        PixelTranslation pixelTranslation2 = PixelTranslation.getPixelTranslation(pixelOrientation2);
        double d = pixelTranslation2.dx - pixelTranslation.dx;
        double d2 = pixelTranslation2.dy - pixelTranslation.dy;
        if (n3 == 2 && (n | n2) == 1 && d == d2 && Math.abs(d) == 0.5) {
            int n4 = d >= 0.0 ? 5 : 4;
            MathTransform[] mathTransformArray = translations;
            synchronized (translations) {
                mathTransform2 = translations[n4];
                if (mathTransform2 == null) {
                    mathTransform2 = MathTransforms.linear(n3, 1.0, d);
                    PixelTranslation.translations[n4] = mathTransform2;
                }
                // ** MonitorExit[var14_12] (shouldn't be in output)
            }
        } else {
            XMatrix xMatrix = Matrices.create(n3 + 1);
            xMatrix.setElement(n, n3, d);
            xMatrix.setElement(n2, n3, d2);
            mathTransform2 = MathTransforms.linear(xMatrix);
        }
        return MathTransforms.concatenate(mathTransform2, mathTransform);
    }

    private static IllegalArgumentException illegalDimension(String string, Object object) {
        return new IllegalArgumentException(Errors.format(73, string, object));
    }

    public String toString() {
        return String.valueOf(this.orientation) + '[' + this.dx + ", " + this.dy + ']';
    }

    static {
        new PixelTranslation(PixelOrientation.CENTER, 0.0, 0.0);
        new PixelTranslation(PixelOrientation.UPPER_LEFT, -0.5, -0.5);
        new PixelTranslation(PixelOrientation.UPPER_RIGHT, 0.5, -0.5);
        new PixelTranslation(PixelOrientation.LOWER_LEFT, -0.5, 0.5);
        new PixelTranslation(PixelOrientation.LOWER_RIGHT, 0.5, 0.5);
        new PixelTranslation("LEFT", -0.5, 0.0);
        new PixelTranslation("RIGHT", 0.5, 0.0);
        new PixelTranslation("UPPER", 0.0, -0.5);
        new PixelTranslation("LOWER", 0.0, 0.5);
    }
}

