/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation.transform;

import net.jcip.annotations.ThreadSafe;
import org.geotoolkit.referencing.operation.matrix.Matrix1;
import org.geotoolkit.referencing.operation.transform.AbstractMathTransform;
import org.geotoolkit.util.ArgumentChecks;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;

@ThreadSafe
public abstract class AbstractMathTransform1D
extends AbstractMathTransform
implements MathTransform1D {
    protected AbstractMathTransform1D() {
    }

    @Override
    public final int getSourceDimensions() {
        return 1;
    }

    @Override
    public final int getTargetDimensions() {
        return 1;
    }

    @Override
    public Matrix transform(double[] dArray, int n, double[] dArray2, int n2, boolean bl) throws TransformException {
        double d = dArray[n];
        if (dArray2 != null) {
            dArray2[n2] = this.transform(d);
        }
        return bl ? new Matrix1(this.derivative(d)) : null;
    }

    @Override
    public Matrix derivative(DirectPosition directPosition) throws TransformException {
        double d;
        if (directPosition == null) {
            d = Double.NaN;
        } else {
            ArgumentChecks.ensureDimensionMatches("point", directPosition, 1);
            d = directPosition.getOrdinate(0);
        }
        return new Matrix1(this.derivative(d));
    }

    @Override
    public MathTransform1D inverse() throws NoninvertibleTransformException {
        return (MathTransform1D)super.inverse();
    }
}

