/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.geomatics.gml;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Polygon;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.geotoolkit.gml.xml.AbstractGeometry;
import org.geotoolkit.gml.xml.AbstractRing;
import org.geotoolkit.gml.xml.AbstractRingProperty;
import org.geotoolkit.gml.xml.v321.AbstractRingPropertyType;
import org.geotoolkit.gml.xml.v321.AbstractRingType;
import org.geotoolkit.gml.xml.v321.AbstractSurfacePatchType;
import org.geotoolkit.gml.xml.v321.PolygonPatchType;
import org.geotoolkit.gml.xml.v321.PolygonType;
import org.geotoolkit.gml.xml.v321.RectangleType;
import org.geotoolkit.gml.xml.v321.SurfacePatchArrayPropertyType;
import org.geotoolkit.gml.xml.v321.SurfaceType;
import org.geotoolkit.gml.xml.v321.TriangleType;
import org.geotoolkit.xml.MarshallerPool;
import org.opengis.cite.geomatics.gml.CoordinateListFactory;
import org.opengis.cite.geomatics.gml.CurveCoordinateListFactory;
import org.opengis.cite.geomatics.gml.GmlUtils;
import org.opengis.cite.geomatics.gml.SurfacePatchType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SurfaceCoordinateListFactory
implements CoordinateListFactory {
    private static final Unmarshaller GML_UNMARSHALLER = SurfaceCoordinateListFactory.initGmlUnmarshaller();
    private static CurveCoordinateListFactory curveCoordFactory = new CurveCoordinateListFactory();
    private static Map<String, SurfacePatchType> patchTypeMap = SurfaceCoordinateListFactory.loadPatchTypeMap();

    private static Unmarshaller initGmlUnmarshaller() {
        Unmarshaller unmarshaller = null;
        try {
            MarshallerPool pool = new MarshallerPool("org.geotoolkit.gml.xml.v321");
            unmarshaller = pool.acquireUnmarshaller();
        }
        catch (JAXBException je) {
            throw new RuntimeException(je);
        }
        return unmarshaller;
    }

    private static Map<String, SurfacePatchType> loadPatchTypeMap() {
        patchTypeMap = new HashMap<String, SurfacePatchType>();
        patchTypeMap.put(PolygonPatchType.class.getName(), SurfacePatchType.POLYGON);
        patchTypeMap.put(RectangleType.class.getName(), SurfacePatchType.RECTANGLE);
        patchTypeMap.put(TriangleType.class.getName(), SurfacePatchType.TRIANGLE);
        return patchTypeMap;
    }

    @Override
    public List<Coordinate> createCoordinateList(AbstractGeometry gmlGeom) {
        List<Coordinate> coordList = null;
        if (SurfaceType.class.isInstance(gmlGeom)) {
            SurfaceType surface = (SurfaceType)SurfaceType.class.cast(gmlGeom);
            coordList = this.exteriorBoundaryOfSurface((SurfacePatchArrayPropertyType)surface.getPatches().getValue(), surface.getSrsName());
        } else if (PolygonType.class.isInstance(gmlGeom)) {
            coordList = this.exteriorBoundaryOfPolygon((PolygonType)PolygonType.class.cast(gmlGeom));
        } else {
            throw new RuntimeException("Unsupported surface type: " + gmlGeom.getClass().getName());
        }
        return coordList;
    }

    public List<Coordinate> createCoordinateList(Element gmlSurface) {
        List<Coordinate> coordList;
        block4: {
            coordList = null;
            try {
                if (GmlUtils.hasChildElement(gmlSurface, "http://www.opengis.net/gml/3.2", "patches")) {
                    Node patchesNode = gmlSurface.getElementsByTagNameNS("http://www.opengis.net/gml/3.2", "patches").item(0);
                    JAXBElement patchArray = (JAXBElement)GML_UNMARSHALLER.unmarshal(patchesNode);
                    coordList = this.exteriorBoundaryOfSurface((SurfacePatchArrayPropertyType)patchArray.getValue(), gmlSurface.getAttribute("srsName"));
                    break block4;
                }
                if (GmlUtils.hasChildElement(gmlSurface, "http://www.opengis.net/gml/3.2", "exterior")) {
                    JAXBElement polygon = (JAXBElement)GML_UNMARSHALLER.unmarshal((Node)gmlSurface);
                    coordList = this.exteriorBoundaryOfPolygon((PolygonType)polygon.getValue());
                    break block4;
                }
                throw new RuntimeException("Unsupported surface type: " + gmlSurface.getNodeName());
            }
            catch (JAXBException je) {
                throw new RuntimeException(je);
            }
        }
        return coordList;
    }

    public Set<List<Coordinate>> interiorCoordinatesSet(AbstractGeometry gmlGeom) {
        Set<List<Coordinate>> set = null;
        if (SurfaceType.class.isInstance(gmlGeom)) {
            SurfaceType surface = (SurfaceType)SurfaceType.class.cast(gmlGeom);
            set = this.interiorBoundariesOfSurface((SurfacePatchArrayPropertyType)surface.getPatches().getValue(), surface.getSrsName());
        } else if (PolygonType.class.isInstance(gmlGeom)) {
            set = this.interiorBoundariesOfPolygon((PolygonType)PolygonType.class.cast(gmlGeom));
        } else {
            throw new RuntimeException("Unsupported surface type: " + gmlGeom.getClass().getName());
        }
        return set;
    }

    public Set<List<Coordinate>> interiorCoordinatesSet(Element gmlSurface) {
        Set<List<Coordinate>> set;
        block4: {
            set = null;
            try {
                if (GmlUtils.hasChildElement(gmlSurface, "http://www.opengis.net/gml/3.2", "patches")) {
                    Node patchesNode = gmlSurface.getElementsByTagNameNS("http://www.opengis.net/gml/3.2", "patches").item(0);
                    JAXBElement patchArray = (JAXBElement)GML_UNMARSHALLER.unmarshal(patchesNode);
                    set = this.interiorBoundariesOfSurface((SurfacePatchArrayPropertyType)patchArray.getValue(), gmlSurface.getAttribute("srsName"));
                    break block4;
                }
                if (GmlUtils.hasChildElement(gmlSurface, "http://www.opengis.net/gml/3.2", "interior")) {
                    JAXBElement polygon = (JAXBElement)GML_UNMARSHALLER.unmarshal((Node)gmlSurface);
                    set = this.interiorBoundariesOfPolygon((PolygonType)polygon.getValue());
                    break block4;
                }
                throw new RuntimeException("Unsupported surface type: " + gmlSurface.getNodeName());
            }
            catch (JAXBException je) {
                throw new RuntimeException(je);
            }
        }
        return set;
    }

    List<Coordinate> exteriorBoundaryOfSurface(SurfacePatchArrayPropertyType patchArray, String srsName) {
        List<JAXBElement<? extends AbstractSurfacePatchType>> patchList = patchArray.getAbstractSurfacePatch();
        Iterator<JAXBElement<? extends AbstractSurfacePatchType>> patchItr = patchList.iterator();
        GeometryFactory geomFactory = new GeometryFactory();
        HashSet<Polygon> geomSet = new HashSet<Polygon>();
        while (patchItr.hasNext()) {
            AbstractSurfacePatchType patch = (AbstractSurfacePatchType)patchItr.next().getValue();
            String className = patch.getClass().getName();
            SurfacePatchType patchType = patchTypeMap.get(className);
            if (null == patchType) {
                throw new RuntimeException("Unsupported surface patch type: " + className);
            }
            AbstractRingType exterior = patchType.getExteriorBoundary(patch);
            exterior.setSrsName(srsName);
            List<Coordinate> extCoords = curveCoordFactory.createCoordinateList(exterior);
            Polygon polygon = geomFactory.createPolygon(extCoords.toArray(new Coordinate[0]));
            geomSet.add(polygon);
        }
        GeometryCollection geomColl = geomFactory.createGeometryCollection(geomSet.toArray(new Geometry[0]));
        Geometry surface = geomColl.union();
        ArrayList<Coordinate> coordList = new ArrayList<Coordinate>();
        coordList.addAll(Arrays.asList(surface.getCoordinates()));
        return coordList;
    }

    List<Coordinate> exteriorBoundaryOfPolygon(PolygonType gmlPolygon) {
        AbstractRingType exterior = gmlPolygon.getExterior().getAbstractRing();
        if (null == exterior.getSrsName()) {
            exterior.setSrsName(gmlPolygon.getSrsName());
        }
        return curveCoordFactory.createCoordinateList(exterior);
    }

    Set<List<Coordinate>> interiorBoundariesOfPolygon(PolygonType gmlPolygon) {
        HashSet<List<Coordinate>> set = new HashSet<List<Coordinate>>();
        Iterator<AbstractRingPropertyType> ringItr = gmlPolygon.getInterior().iterator();
        while (ringItr.hasNext()) {
            AbstractRing interior = ((AbstractRingProperty)ringItr.next()).getAbstractRing();
            if (null == interior.getSrsName()) {
                interior.setSrsName(gmlPolygon.getSrsName());
            }
            set.add(curveCoordFactory.createCoordinateList(interior));
        }
        return set;
    }

    Set<List<Coordinate>> interiorBoundariesOfSurface(SurfacePatchArrayPropertyType patchArray, String srsName) {
        List<JAXBElement<? extends AbstractSurfacePatchType>> patches = patchArray.getAbstractSurfacePatch();
        Iterator<JAXBElement<? extends AbstractSurfacePatchType>> patchItr = patches.iterator();
        HashSet<List<Coordinate>> set = new HashSet<List<Coordinate>>();
        while (patchItr.hasNext()) {
            AbstractSurfacePatchType patch = (AbstractSurfacePatchType)patchItr.next().getValue();
            String className = patch.getClass().getName();
            SurfacePatchType patchType = patchTypeMap.get(className);
            if (null == patchType) {
                throw new RuntimeException("Unsupported surface patch type: " + className);
            }
            Set<AbstractRingType> interiorRings = patchType.getInteriorBoundaries(patch);
            for (AbstractRing abstractRing : interiorRings) {
                if (null == abstractRing.getSrsName()) {
                    abstractRing.setSrsName(srsName);
                }
                set.add(curveCoordFactory.createCoordinateList(abstractRing));
            }
        }
        return set;
    }
}

