/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.iso19142.paging;

import java.util.logging.Level;
import org.opengis.cite.iso19142.ErrorMessage;
import org.opengis.cite.iso19142.SuiteAttribute;
import org.opengis.cite.iso19142.util.ServiceMetadataUtils;
import org.opengis.cite.iso19142.util.TestSuiteLogger;
import org.testng.ITestContext;
import org.testng.SkipException;
import org.testng.annotations.BeforeTest;
import org.w3c.dom.Document;

public class ResponsePaging {
    public static final String IMPL_RESULT_PAGING = "ImplementsResultPaging";
    public static final String CACHE_TIMEOUT = "ResponseCacheTimeout";
    public static final String PAGING_IS_CONSISTENT = "PagingIsTransactionSafe";
    public static final String COUNT_DEFAULT = "CountDefault";

    @BeforeTest
    public void implementsResponsePaging(ITestContext testContext) {
        Document wfsMetadata = (Document)testContext.getSuite().getAttribute(SuiteAttribute.TEST_SUBJECT.getName());
        if (!ServiceMetadataUtils.implementsConformanceClass(wfsMetadata, IMPL_RESULT_PAGING)) {
            throw new SkipException(ErrorMessage.format("CapabilityNotImplemented", IMPL_RESULT_PAGING));
        }
        String pagingIsConsistent = ServiceMetadataUtils.getConstraintValue(wfsMetadata, PAGING_IS_CONSISTENT);
        testContext.setAttribute(PAGING_IS_CONSISTENT, Boolean.valueOf(pagingIsConsistent));
        String cacheTimeout = ServiceMetadataUtils.getConstraintValue(wfsMetadata, CACHE_TIMEOUT);
        String countDefault = ServiceMetadataUtils.getConstraintValue(wfsMetadata, COUNT_DEFAULT);
        try {
            if (!cacheTimeout.isEmpty()) {
                testContext.setAttribute(CACHE_TIMEOUT, Integer.valueOf(cacheTimeout));
            }
            if (!countDefault.isEmpty()) {
                testContext.setAttribute(COUNT_DEFAULT, Integer.valueOf(countDefault));
            }
        }
        catch (NumberFormatException e) {
            TestSuiteLogger.log(Level.WARNING, String.format("Invalid constraint (expected integer value): %s", e.getMessage()));
        }
    }
}

