/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.iso19142.basic.filter.temporal;

import com.sun.jersey.api.client.ClientResponse;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.transform.dom.DOMSource;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSTypeDefinition;
import org.opengis.cite.geomatics.gml.GmlUtils;
import org.opengis.cite.geomatics.time.TemporalUtils;
import org.opengis.cite.iso19142.ErrorMessage;
import org.opengis.cite.iso19142.ProtocolBinding;
import org.opengis.cite.iso19142.basic.filter.temporal.AbstractTemporalTest;
import org.opengis.cite.iso19142.basic.filter.temporal.TemporalQuery;
import org.opengis.cite.iso19142.util.TimeUtils;
import org.opengis.cite.iso19142.util.WFSMessage;
import org.opengis.temporal.RelativePosition;
import org.opengis.temporal.TemporalGeometricPrimitive;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DuringTests
extends AbstractTemporalTest {
    private static final String DURING_OP = "During";

    @Test(description="See ISO 19143: 7.14.6, A.9", dataProvider="protocol-featureType")
    public void duringPeriod(ProtocolBinding binding, QName featureType) {
        AbstractTemporalTest.TemporalProperty temporalProperty = this.findTemporalProperty(featureType);
        Document gmlTimeLiteral = TimeUtils.periodAsGML(temporalProperty.getExtent());
        WFSMessage.appendSimpleQuery(this.reqEntity, featureType);
        Element valueRef = WFSMessage.createValueReference(temporalProperty.getProperty());
        WFSMessage.addTemporalPredicate(this.reqEntity, DURING_OP, gmlTimeLiteral, valueRef);
        ClientResponse rsp = this.wfsClient.getFeature(new DOMSource(this.reqEntity), binding);
        this.rspEntity = this.extractBodyAsDocument(rsp);
        Assert.assertEquals((int)rsp.getStatus(), (int)ClientResponse.Status.OK.getStatusCode(), (String)ErrorMessage.get("UnexpectedStatus"));
        List<Node> temporalNodes = TemporalQuery.extractTemporalNodes(this.rspEntity, temporalProperty.getProperty(), this.getModel());
        this.assertDuring(temporalNodes, temporalProperty.getProperty(), gmlTimeLiteral);
    }

    void assertDuring(List<Node> temporalNodes, XSElementDeclaration propertyDecl, Document gmlTimeLiteral) {
        Assert.assertFalse((boolean)temporalNodes.isEmpty(), (String)String.format("No temporal values found in results: property is %s.", propertyDecl));
        TemporalGeometricPrimitive t2 = GmlUtils.gmlToTemporalGeometricPrimitive((Element)gmlTimeLiteral.getDocumentElement());
        XSTypeDefinition typeDef = propertyDecl.getTypeDefinition();
        for (Node timeNode : temporalNodes) {
            TemporalGeometricPrimitive t1 = null;
            t1 = typeDef.getTypeCategory() == 16 || ((XSComplexTypeDefinition)typeDef).getContentType() == 1 ? TemporalQuery.parseTemporalValue(timeNode.getTextContent(), typeDef) : GmlUtils.gmlToTemporalGeometricPrimitive((Element)((Element)timeNode));
            TemporalUtils.assertTemporalRelation((RelativePosition)RelativePosition.DURING, (TemporalGeometricPrimitive)t1, (TemporalGeometricPrimitive)t2);
        }
    }
}

