/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.util.collection;

import java.util.ArrayList;
import java.util.Collection;
import org.geotoolkit.util.NumberRange;
import org.geotoolkit.util.collection.CheckedArrayList;

public abstract class NotifiedCheckedList<E>
extends CheckedArrayList<E> {
    public NotifiedCheckedList(Class<E> type) {
        super(type);
    }

    public NotifiedCheckedList(Class<E> type, int capacity) {
        super(type, capacity);
    }

    protected abstract void notifyAdd(E var1, int var2);

    protected abstract void notifyAdd(Collection<? extends E> var1, NumberRange<Integer> var2);

    protected abstract void notifyChange(E var1, E var2, int var3);

    protected abstract void notifyRemove(E var1, int var2);

    protected abstract void notifyRemove(Collection<? extends E> var1, NumberRange<Integer> var2);

    public boolean add(E element) throws IllegalArgumentException, UnsupportedOperationException {
        if (element == null) {
            return false;
        }
        boolean added = super.add(element);
        if (added) {
            int index = super.size() - 1;
            this.notifyAdd(element, index);
        }
        return added;
    }

    public void add(int index, E element) throws IllegalArgumentException, UnsupportedOperationException {
        super.add(index, element);
        this.notifyAdd(element, index);
    }

    public E set(int index, E element) throws IllegalArgumentException, UnsupportedOperationException {
        Object old = super.set(index, element);
        this.notifyChange(old, element, index);
        return (E)old;
    }

    public boolean addAll(Collection<? extends E> collection) throws IllegalArgumentException, UnsupportedOperationException {
        int startIndex = super.size();
        boolean added = super.addAll(collection);
        if (added) {
            this.notifyAdd(collection, (NumberRange<Integer>)NumberRange.create((int)startIndex, (int)(super.size() - 1)));
        }
        return added;
    }

    public boolean addAll(int index, Collection<? extends E> collection) throws IllegalArgumentException, UnsupportedOperationException {
        boolean added = super.addAll(index, collection);
        if (added) {
            this.notifyAdd(collection, (NumberRange<Integer>)NumberRange.create((int)index, (int)(index + collection.size())));
        }
        return added;
    }

    public boolean remove(Object o) throws UnsupportedOperationException {
        int index = super.indexOf(o);
        if (index >= 0) {
            super.remove(index);
            this.notifyRemove(super.getElementType().cast(o), index);
            return true;
        }
        return false;
    }

    public E remove(int index) throws UnsupportedOperationException {
        Object removed = super.remove(index);
        this.notifyRemove(removed, index);
        return (E)removed;
    }

    public boolean removeAll(Collection<?> c) throws UnsupportedOperationException {
        boolean valid = false;
        for (Object i : c) {
            boolean val = this.remove(i);
            if (!val) continue;
            valid = val;
        }
        return valid;
    }

    public void clear() throws UnsupportedOperationException {
        if (!this.isEmpty()) {
            ArrayList copy = new ArrayList(this);
            NumberRange range = NumberRange.create((int)0, (int)(copy.size() - 1));
            super.clear();
            this.notifyRemove(copy, (NumberRange<Integer>)range);
        }
    }
}

