/*
 * Decompiled with CFR 0.152.
 */
package com.github.andrewoma.dexx.collection.internal.hashmap;

import com.github.andrewoma.dexx.collection.Builder;
import com.github.andrewoma.dexx.collection.BuilderFactory;
import com.github.andrewoma.dexx.collection.Function;
import com.github.andrewoma.dexx.collection.Map;
import com.github.andrewoma.dexx.collection.Pair;
import com.github.andrewoma.dexx.collection.internal.base.AbstractMap;
import com.github.andrewoma.dexx.collection.internal.builder.AbstractSelfBuilder;
import com.github.andrewoma.dexx.collection.internal.hashmap.ListMapIterator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;

public class ListMap<K, V>
extends AbstractMap<K, V> {
    private static final ListMap<Object, Object> EMPTY = new ListMap();

    @NotNull
    public static <K, V> BuilderFactory<Pair<K, V>, ListMap<K, V>> factory() {
        return new BuilderFactory<Pair<K, V>, ListMap<K, V>>(){

            @Override
            @NotNull
            public Builder<Pair<K, V>, ListMap<K, V>> newBuilder() {
                return new AbstractSelfBuilder<Pair<K, V>, ListMap<K, V>>(ListMap.empty()){

                    @Override
                    @NotNull
                    public Builder<Pair<K, V>, ListMap<K, V>> add(Pair<K, V> element) {
                        this.result = ((ListMap)this.result).put(element.component1(), element.component2());
                        return this;
                    }
                };
            }
        };
    }

    @NotNull
    public static <K, V> ListMap<K, V> empty() {
        return EMPTY;
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public V get(@NotNull K key) {
        return null;
    }

    @Override
    @NotNull
    public ListMap<K, V> put(@NotNull K key, V value) {
        return new Node<K, V>(key, value);
    }

    @Override
    @NotNull
    public ListMap<K, V> remove(@NotNull K key) {
        return this;
    }

    @Override
    public <U> void forEach(@NotNull Function<Pair<K, V>, U> f) {
        for (Pair<K, V> pair : this) {
            f.invoke(pair);
        }
    }

    @Override
    @NotNull
    public Iterator<Pair<K, V>> iterator() {
        return new ListMapIterator(this);
    }

    protected K getKey() {
        throw new NoSuchElementException("empty map");
    }

    protected V getValue() {
        throw new NoSuchElementException("empty map");
    }

    public ListMap<K, V> tail() {
        throw new NoSuchElementException("empty map");
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    protected Node<K, V> createNode(K key, V value) {
        return new Node<K, V>(key, value);
    }

    @Override
    public boolean containsKey(@NotNull K key) {
        return false;
    }

    class Node<K, V>
    extends ListMap<K, V> {
        private final K key;
        private final V value;

        Node(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public int size() {
            return this.size0(this, 0);
        }

        private int size0(ListMap<K, V> cur, int acc) {
            return cur.isEmpty() ? acc : this.size0(cur.tail(), acc + 1);
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public V get(@NotNull K key) {
            ListMap<K, V> pairs = this.apply0(this, key);
            return pairs == null ? null : (V)pairs.getValue();
        }

        private ListMap<K, V> apply0(ListMap<K, V> cur, K key) {
            return cur.isEmpty() ? null : (key.equals(cur.getKey()) ? cur : this.apply0(cur.tail(), key));
        }

        @Override
        public ListMap<K, V> tail() {
            return ListMap.this;
        }

        @Override
        @NotNull
        public ListMap<K, V> put(@NotNull K key, V value) {
            Node m3 = this.containsKey(key) ? this.remove((Object)key) : this;
            return m3.createNode(key, value);
        }

        @Override
        @NotNull
        public ListMap<K, V> remove(@NotNull K key) {
            Map acc = ListMap.empty();
            for (Pair pair : this) {
                if (key.equals(pair.component1())) continue;
                acc = acc.put(pair.component1(), pair.component2());
            }
            return acc;
        }

        @Override
        protected K getKey() {
            return this.key;
        }

        @Override
        protected V getValue() {
            return this.value;
        }

        @Override
        public boolean containsKey(@NotNull K key) {
            return this.apply0(this, key) != null;
        }
    }
}

