/*
 * Decompiled with CFR 0.152.
 */
package com.occamlab.te;

import com.occamlab.te.TECore;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SetupOptions {
    public static final String TE_BASE = "TE_BASE";
    private static File teBaseDir = SetupOptions.getBaseConfigDirectory();
    boolean validate = true;
    boolean preload = false;
    File workDir = null;
    String sourcesName = "default";
    ArrayList<File> sources = new ArrayList();

    public SetupOptions() {
        File scriptsDir = new File(teBaseDir, "scripts");
        if (!scriptsDir.exists() && !scriptsDir.mkdirs()) {
            throw new RuntimeException("Failed to create directory at " + scriptsDir.getAbsolutePath());
        }
    }

    public static File getBaseConfigDirectory() {
        File baseDir;
        if (null != teBaseDir) {
            return teBaseDir;
        }
        String basePath = System.getProperty(TE_BASE);
        if (null == basePath) {
            basePath = System.getenv(TE_BASE);
        }
        if (null == basePath) {
            basePath = System.getProperty("user.home") + System.getProperty("file.separator") + "teamengine";
        }
        if (!(baseDir = new File(basePath)).isDirectory()) {
            baseDir.mkdirs();
        }
        Logger.getLogger(SetupOptions.class.getName()).log(Level.CONFIG, "Using TE_BASE at " + baseDir);
        return baseDir;
    }

    public static boolean recordingInfo(String testName) throws ParserConfigurationException, SAXException, IOException {
        TECore.rootTestName.clear();
        String path = SetupOptions.getBaseConfigDirectory() + "/config.xml";
        if (new File(path).exists()) {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setExpandEntityReferences(false);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(path);
            NodeList nodeListForStandardTag = doc.getElementsByTagName("standard");
            if (null != nodeListForStandardTag && nodeListForStandardTag.getLength() > 0) {
                for (int i = 0; i < nodeListForStandardTag.getLength(); ++i) {
                    Element elementStandard = (Element)nodeListForStandardTag.item(i);
                    if (!testName.equals(elementStandard.getElementsByTagName("local-name").item(0).getTextContent()) || null == elementStandard.getElementsByTagName("record").item(0)) continue;
                    System.setProperty("Record", "True");
                    NodeList rootTestNameArray = elementStandard.getElementsByTagName("test-name");
                    if (null != rootTestNameArray && rootTestNameArray.getLength() > 0) {
                        for (int counter = 0; counter < rootTestNameArray.getLength(); ++counter) {
                            Element rootTestName = (Element)rootTestNameArray.item(counter);
                            TECore.rootTestName.add(rootTestName.getTextContent());
                        }
                    }
                    return true;
                }
            }
        }
        System.setProperty("Record", "False");
        return false;
    }

    public String getSourcesName() {
        return this.sourcesName;
    }

    public void setSourcesName(String sourcesName) {
        this.sourcesName = sourcesName;
    }

    public File getWorkDir() {
        if (null == this.workDir) {
            File dir2 = new File(teBaseDir, "work");
            if (!dir2.exists() && !dir2.mkdir()) {
                throw new RuntimeException("Failed to create directory at " + dir2.getAbsolutePath());
            }
            this.workDir = dir2;
        }
        return this.workDir;
    }

    public List<File> getSources() {
        return this.sources;
    }

    public void addSource(File source) {
        this.sources.add(source);
    }

    public Element getParamsElement() {
        return null;
    }

    public boolean isValidate() {
        return this.validate;
    }

    public void setValidate(boolean validate) {
        this.validate = validate;
    }

    public boolean isPreload() {
        return this.preload;
    }

    public void setPreload(boolean preload) {
        this.preload = preload;
    }
}

