/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.StringTokenizer;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Whitespace;

public class SaxonScript
extends StyleElement {
    private Class javaClass = null;
    private String implementsURI = null;
    private String language = null;

    public void prepareAttributes() throws XPathException {
        String languageAtt = null;
        String implementsAtt = null;
        String srcAtt = null;
        String archiveAtt = null;
        AttributeCollection atts = this.getAttributeList();
        for (int a = 0; a < atts.getLength(); ++a) {
            int nc = atts.getNameCode(a);
            String f = this.getNamePool().getClarkName(nc);
            if (f == "language") {
                languageAtt = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f == "implements-prefix") {
                implementsAtt = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f == "src") {
                srcAtt = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f == "archive") {
                archiveAtt = Whitespace.trim(atts.getValue(a));
                continue;
            }
            this.checkUnknownAttribute(nc);
        }
        if (implementsAtt == null) {
            this.reportAbsence("implements-prefix");
            return;
        }
        this.implementsURI = this.getURIForPrefix(implementsAtt, false);
        if (this.implementsURI == null) {
            this.undeclaredNamespaceError(implementsAtt, "SXXF0002");
            return;
        }
        if (languageAtt == null) {
            this.reportAbsence("language");
            return;
        }
        this.language = languageAtt;
        if (this.language.equals("java")) {
            URL base;
            if (srcAtt == null) {
                this.compileError("For java, the src attribute is mandatory");
                return;
            }
            if (!srcAtt.startsWith("java:")) {
                this.compileError("The src attribute must be a URI of the form java:full.class.Name");
                return;
            }
            String className = srcAtt.substring(5);
            if (archiveAtt == null) {
                try {
                    this.javaClass = this.getConfiguration().getClass(className, false, null);
                }
                catch (XPathException err) {
                    this.compileError(err);
                    return;
                }
            }
            try {
                base = new URL(this.getBaseURI());
            }
            catch (MalformedURLException err) {
                this.compileError("Invalid base URI " + this.getBaseURI());
                return;
            }
            StringTokenizer st = new StringTokenizer(archiveAtt, " \t\n\r", false);
            int count = 0;
            while (st.hasMoreTokens()) {
                ++count;
                st.nextToken();
            }
            URL[] urls = new URL[count];
            count = 0;
            st = new StringTokenizer(archiveAtt, " \t\n\r", false);
            while (st.hasMoreTokens()) {
                String s2 = st.nextToken();
                try {
                    urls[count++] = new URL(base, s2);
                }
                catch (MalformedURLException err) {
                    this.compileError("Invalid URL " + s2);
                    return;
                }
            }
            try {
                this.javaClass = new URLClassLoader(urls).loadClass(className);
            }
            catch (ClassNotFoundException err) {
                this.compileError("Cannot find class " + className + " in the specified archive" + (count > 1 ? "s" : ""));
            }
            catch (NoClassDefFoundError err2) {
                this.compileError("Cannot use the archive attribute with this Java VM");
            }
        } else {
            this.compileError("The only language supported for Saxon extension functions is 'java'");
        }
        this.getPrincipalStylesheet().declareJavaClass(this.implementsURI, this.javaClass);
    }

    public void validate() throws XPathException {
        this.checkTopLevel(null);
    }

    public Expression compile(Executable exec) throws XPathException {
        return null;
    }
}

