/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.apache.jena.atlas.io.AWriter;
import org.apache.jena.atlas.io.AWriterBase;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.lib.Closeable;

public class IndentedWriter
extends AWriterBase
implements AWriter,
Closeable {
    public static final IndentedWriter stdout = new IndentedWriter(System.out);
    public static final IndentedWriter stderr = new IndentedWriter(System.err);
    protected Writer out = null;
    protected static final int INDENT = 2;
    protected int unitIndent = 2;
    protected int currentIndent = 0;
    protected int column = 0;
    protected int row = 1;
    protected boolean lineNumbers = false;
    protected boolean startingNewLine = true;
    private char padChar = (char)32;
    private String endOfLineMarker = null;
    private String padString = null;
    protected boolean flatMode = false;
    private boolean flushOnNewline = false;
    private char lastChar = '\u0000';
    private static int WidthLineNumber;

    public IndentedWriter(OutputStream outStream) {
        this(outStream, false);
    }

    public IndentedWriter(OutputStream outStream, boolean withLineNumbers) {
        this(IndentedWriter.makeWriter(outStream), withLineNumbers);
    }

    private static Writer makeWriter(OutputStream out) {
        return IO.asBufferedUTF8(out);
    }

    protected IndentedWriter(Writer writer) {
        this(writer, false);
    }

    protected IndentedWriter(Writer writer, boolean withLineNumbers) {
        this.out = writer;
        this.lineNumbers = withLineNumbers;
        this.startingNewLine = true;
    }

    @Override
    public void print(String str) {
        if (str == null) {
            str = "null";
        }
        for (int i = 0; i < str.length(); ++i) {
            this.printOneChar(str.charAt(i));
        }
    }

    @Override
    public void printf(String formatStr, Object ... args) {
        this.print(String.format(formatStr, args));
    }

    @Override
    public void print(char ch) {
        this.printOneChar(ch);
    }

    @Override
    public void println(String str) {
        this.print(str);
        this.newline();
    }

    public void println(char ch) {
        this.print(ch);
        this.newline();
    }

    @Override
    public void println() {
        this.newline();
    }

    @Override
    public void print(char[] cbuf) {
        for (char aCbuf : cbuf) {
            this.printOneChar(aCbuf);
        }
    }

    public void print(String s2, int n) {
        for (int i = 0; i < n; ++i) {
            this.print(s2);
        }
    }

    public void print(char ch, int n) {
        this.lineStart();
        for (int i = 0; i < n; ++i) {
            this.printOneChar(ch);
        }
    }

    private void printOneChar(char ch) {
        if (ch == '\n' && this.lastChar == '\r') {
            this.lastChar = ch;
            return;
        }
        this.lineStart();
        this.lastChar = ch;
        if (ch == '\n' || ch == '\r') {
            this.newline();
            return;
        }
        this.write$(ch);
        ++this.column;
    }

    private void write$(char ch) {
        try {
            this.out.write(ch);
        }
        catch (IOException ex) {
            IO.exception(ex);
        }
    }

    private void write$(String s2) {
        try {
            this.out.write(s2);
        }
        catch (IOException ex) {
            IO.exception(ex);
        }
    }

    public void newline() {
        this.lineStart();
        if (this.endOfLineMarker != null) {
            this.print(this.endOfLineMarker);
        }
        if (!this.flatMode) {
            this.write$('\n');
        }
        this.startingNewLine = true;
        ++this.row;
        this.column = 0;
        if (this.flushOnNewline) {
            this.flush();
        }
    }

    private boolean atStartOfLine() {
        return this.column <= this.currentIndent;
    }

    public void ensureStartOfLine() {
        if (!this.atStartOfLine()) {
            this.newline();
        }
    }

    @Override
    public void close() {
        IO.close(this.out);
    }

    @Override
    public void flush() {
        IO.flush(this.out);
    }

    public void pad() {
        if (this.startingNewLine && this.currentIndent > 0) {
            this.lineStart();
        }
        this.padInternal();
    }

    public void pad(int col) {
        this.pad(col, false);
    }

    public void pad(int col, boolean absoluteColumn) {
        if (!absoluteColumn) {
            col += this.currentIndent;
        }
        int spaces = col - this.column;
        for (int i = 0; i < spaces; ++i) {
            this.write$(' ');
            ++this.column;
        }
    }

    private void padInternal() {
        if (this.padString == null) {
            for (int i = this.column; i < this.currentIndent; ++i) {
                this.write$(this.padChar);
                ++this.column;
            }
        } else {
            for (int i = this.column; i < this.currentIndent; i += this.padString.length()) {
                this.write$(this.padString);
                this.column += this.padString.length();
            }
        }
    }

    public int getRow() {
        return this.row;
    }

    public int getCol() {
        if (this.currentIndent > this.column) {
            return this.currentIndent;
        }
        return this.column;
    }

    public int getAbsoluteIndent() {
        return this.currentIndent;
    }

    public void setAbsoluteIndent(int x) {
        this.currentIndent = x;
    }

    public int getCurrentOffset() {
        int x = this.getCol() - this.getAbsoluteIndent();
        if (x >= 0) {
            return x;
        }
        return 0;
    }

    public boolean hasLineNumbers() {
        return this.lineNumbers;
    }

    public void setLineNumbers(boolean lineNumbers) {
        this.lineNumbers = lineNumbers;
    }

    public String getEndOfLineMarker() {
        return this.endOfLineMarker;
    }

    public void setEndOfLineMarker(String marker) {
        this.endOfLineMarker = marker;
    }

    public boolean inFlatMode() {
        return this.flatMode;
    }

    public void setFlatMode(boolean flatMode) {
        this.flatMode = flatMode;
    }

    public boolean getFlushOnNewline() {
        return this.flushOnNewline;
    }

    public void setFlushOnNewline(boolean flushOnNewline) {
        this.flushOnNewline = flushOnNewline;
    }

    public char getPadChar() {
        return this.padChar;
    }

    public void setPadChar(char ch) {
        this.padChar = ch;
    }

    public String getPadString() {
        return this.padString;
    }

    public void setPadString(String str) {
        this.padString = str;
        this.unitIndent = str.length();
    }

    public void incIndent() {
        this.incIndent(this.unitIndent);
    }

    public void incIndent(int x) {
        this.currentIndent += x;
    }

    public void decIndent() {
        this.decIndent(this.unitIndent);
    }

    public void decIndent(int x) {
        this.currentIndent -= x;
    }

    public void setUnitIndent(int x) {
        this.unitIndent = x;
    }

    public int getUnitIndent() {
        return this.unitIndent;
    }

    public boolean atLineStart() {
        return this.startingNewLine;
    }

    private void lineStart() {
        if (this.flatMode) {
            if (this.startingNewLine && this.row > 1) {
                this.write$(' ');
            }
            this.startingNewLine = false;
            return;
        }
        if (this.startingNewLine) {
            this.insertLineNumber();
        }
        this.padInternal();
        this.startingNewLine = false;
    }

    private void insertLineNumber() {
        if (!this.lineNumbers) {
            return;
        }
        String s2 = Integer.toString(this.row);
        for (int i = 0; i < WidthLineNumber - s2.length(); ++i) {
            this.write$(' ');
        }
        this.write$(s2);
        this.write$(' ');
    }

    public String toString() {
        return String.format("Indent = %d : [%d, %d]", this.currentIndent, this.row, this.column);
    }

    static {
        stdout.setFlushOnNewline(true);
        stderr.setFlushOnNewline(true);
        WidthLineNumber = 3;
    }
}

