/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.geometry.isoonjts.spatialschema.geometry.primitive;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.geotoolkit.geometry.GeneralDirectPosition;
import org.geotoolkit.geometry.isoonjts.JTSUtils;
import org.geotoolkit.geometry.isoonjts.spatialschema.geometry.AbstractJTSGeometry;
import org.geotoolkit.geometry.isoonjts.spatialschema.geometry.JTSGeometry;
import org.geotoolkit.geometry.isoonjts.spatialschema.geometry.NotifyingArrayList;
import org.geotoolkit.geometry.isoonjts.spatialschema.geometry.geometry.JTSLineString;
import org.geotoolkit.internal.jaxb.CurveArrayType;
import org.geotoolkit.util.Utilities;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.complex.CompositeCurve;
import org.opengis.geometry.coordinate.GenericCurve;
import org.opengis.geometry.coordinate.ParamForPoint;
import org.opengis.geometry.coordinate.PointArray;
import org.opengis.geometry.coordinate.Position;
import org.opengis.geometry.primitive.Curve;
import org.opengis.geometry.primitive.CurveBoundary;
import org.opengis.geometry.primitive.CurveSegment;
import org.opengis.geometry.primitive.OrientableCurve;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

@XmlType(name="CurveType", namespace="http://www.opengis.net/gml")
public class JTSCurve
extends AbstractJTSGeometry
implements Curve {
    private List<CurveSegment> curveSegments = new NotifyingArrayList<CurveSegment>(this);

    public JTSCurve() {
        this(null);
    }

    public JTSCurve(CoordinateReferenceSystem crs) {
        super(crs);
    }

    @Override
    public CurveBoundary getBoundary() {
        return (CurveBoundary)super.getBoundary();
    }

    public final List<CurveSegment> getSegments() {
        return this.curveSegments;
    }

    @Override
    public final DirectPosition getStartPoint() {
        return this.curveSegments.get(0).getStartPoint();
    }

    @Override
    public final DirectPosition getEndPoint() {
        return this.curveSegments.get(this.curveSegments.size() - 1).getEndPoint();
    }

    @Override
    public double[] getTangent(double s2) {
        return new double[0];
    }

    @Override
    public final double getStartParam() {
        return 0.0;
    }

    @Override
    public final double getEndParam() {
        return this.length(0.0, this.getEndConstructiveParam());
    }

    @Override
    public final double getStartConstructiveParam() {
        return 0.0;
    }

    @Override
    public final double getEndConstructiveParam() {
        return this.curveSegments.size();
    }

    @Override
    public final DirectPosition forConstructiveParam(double cp) {
        int n = this.curveSegments.size();
        int i = (int)cp;
        if (i < 0) {
            i = 0;
        } else if (i > n) {
            i = n;
        }
        if (i == n) {
            return this.curveSegments.get(n - 1).getEndPoint();
        }
        CurveSegment cs = this.curveSegments.get(i);
        double d = cp - (double)i;
        return cs.forConstructiveParam((1.0 - d) * cs.getStartConstructiveParam() + d * cs.getEndConstructiveParam());
    }

    @Override
    public final DirectPosition forParam(double s2) {
        return null;
    }

    @Override
    public ParamForPoint getParamForPoint(DirectPosition p) {
        return null;
    }

    @Override
    public double length(DirectPosition point1, DirectPosition point2) {
        return 0.0;
    }

    @Override
    public double length(double cparam1, double cparam2) {
        return 0.0;
    }

    @Override
    public org.opengis.geometry.coordinate.LineString asLineString(double maxSpacing, double maxOffset) {
        int count = this.curveSegments.size();
        if (count == 1) {
            CurveSegment segment1 = this.curveSegments.get(0);
            if (segment1 instanceof org.opengis.geometry.coordinate.LineString) {
                return (org.opengis.geometry.coordinate.LineString)segment1;
            }
        } else if (count > 0) {
            boolean allLineString = true;
            JTSLineString lsi = new JTSLineString();
            Object ls = null;
            List<Position> retList = lsi.getControlPoints().positions();
            Position lastPoint = null;
            List<Position> segList = null;
            for (int i = 0; i < count && allLineString; ++i) {
                CurveSegment segment = this.curveSegments.get(0);
                if (segment instanceof org.opengis.geometry.coordinate.LineString) {
                    segList = ((org.opengis.geometry.coordinate.LineString)segment).getControlPoints().positions();
                    if (segList.get(0).equals(lastPoint)) {
                        retList.remove(retList.size() - 1);
                    }
                    retList.addAll(segList);
                    lastPoint = retList.get(retList.size() - 1);
                    continue;
                }
                allLineString = false;
            }
            if (allLineString) {
                return lsi;
            }
        }
        return null;
    }

    @Override
    public CompositeCurve getComposite() {
        return null;
    }

    @Override
    public int getOrientation() {
        return 1;
    }

    @Override
    public Curve getPrimitive() {
        return this;
    }

    public Set getContainedPrimitives() {
        return Collections.EMPTY_SET;
    }

    public Set getContainingPrimitives() {
        return Collections.EMPTY_SET;
    }

    public Set getComplexes() {
        return Collections.EMPTY_SET;
    }

    @Override
    public OrientableCurve[] getProxy() {
        return null;
    }

    @Override
    public GenericCurve reverse() {
        return null;
    }

    @Override
    public PointArray getSamplePoints() {
        return null;
    }

    @XmlElement(name="segments", namespace="http://www.opengis.net/gml")
    public CurveArrayType getCurveArray() {
        return new CurveArrayType(this.curveSegments);
    }

    public void setCurveArray(CurveArrayType array) {
        this.curveSegments = new NotifyingArrayList<CurveSegment>(this);
        for (CurveSegment c : array.getCurveSegments()) {
            JTSLineString line = (JTSLineString)c;
            JTSLineString newLine = new JTSLineString(this.getCoordinateReferenceSystem());
            for (Position p : line.getPositions()) {
                if (!(p instanceof GeneralDirectPosition)) continue;
                ((GeneralDirectPosition)p).setCoordinateReferenceSystem(this.getCoordinateReferenceSystem());
                newLine.getPositions().add(p);
            }
            this.curveSegments.add(newLine);
        }
    }

    @Override
    protected Geometry computeJTSPeer() {
        int n = this.curveSegments.size();
        ArrayList<Coordinate> allCoords = new ArrayList<Coordinate>();
        for (int i = 0; i < n; ++i) {
            JTSGeometry g2 = (JTSGeometry)((Object)this.curveSegments.get(i));
            LineString jts = (LineString)g2.getJTSGeometry();
            int m3 = jts.getNumPoints();
            for (int j = 0; j < m3; ++j) {
                allCoords.add(jts.getCoordinateN(j));
            }
            if (i == n - 1) continue;
            allCoords.remove(allCoords.size() - 1);
        }
        Coordinate[] coords = new Coordinate[allCoords.size()];
        allCoords.toArray(coords);
        return JTSUtils.GEOMETRY_FACTORY.createLineString(coords);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append("segments:");
        if (!this.curveSegments.isEmpty()) {
            sb.append("\n");
            for (CurveSegment seg : this.curveSegments) {
                sb.append(seg.toString()).append("\n");
            }
        }
        return sb.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof JTSCurve && super.equals(object)) {
            JTSCurve that = (JTSCurve)object;
            return Utilities.equals(this.curveSegments, that.curveSegments);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = 89 * hash + (this.curveSegments != null ? ((Object)this.curveSegments).hashCode() : 0);
        return hash;
    }
}

