/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.internal.jaxb;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.geotoolkit.geometry.GeneralDirectPosition;
import org.geotoolkit.geometry.isoonjts.spatialschema.geometry.geometry.JTSLineString;
import org.geotoolkit.geometry.isoonjts.spatialschema.geometry.geometry.JTSPolygon;
import org.geotoolkit.geometry.isoonjts.spatialschema.geometry.primitive.JTSCurve;
import org.geotoolkit.geometry.isoonjts.spatialschema.geometry.primitive.JTSRing;
import org.geotoolkit.geometry.isoonjts.spatialschema.geometry.primitive.JTSSurfaceBoundary;
import org.geotoolkit.internal.jaxb.CoordinateReferenceSystemAdapter;
import org.geotoolkit.internal.jaxb.RingAdapter;
import org.opengis.geometry.coordinate.PointArray;
import org.opengis.geometry.coordinate.Position;
import org.opengis.geometry.primitive.CurveSegment;
import org.opengis.geometry.primitive.Primitive;
import org.opengis.geometry.primitive.Ring;
import org.opengis.geometry.primitive.SurfaceBoundary;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class PolygonType {
    @XmlAttribute(name="srsName")
    @XmlJavaTypeAdapter(value=CoordinateReferenceSystemAdapter.class)
    private CoordinateReferenceSystem coordinateReferenceSystem;
    @XmlElement(namespace="http://www.opengis.net/gml")
    @XmlJavaTypeAdapter(value=RingAdapter.class)
    private Ring exterior;
    @XmlElement(namespace="http://www.opengis.net/gml")
    @XmlJavaTypeAdapter(value=RingAdapter.class)
    private Ring outerBoundaryIs;
    @XmlElement(namespace="http://www.opengis.net/gml")
    @XmlJavaTypeAdapter(value=RingAdapter.class)
    private List<Ring> interior;
    @XmlElement(namespace="http://www.opengis.net/gml")
    @XmlJavaTypeAdapter(value=RingAdapter.class)
    private List<Ring> innerBoundaryIs;

    public PolygonType() {
    }

    public PolygonType(JTSPolygon poly) {
        if (poly != null && poly.getBoundary() != null) {
            this.coordinateReferenceSystem = poly.getBoundary().getCoordinateReferenceSystem();
            this.exterior = poly.getBoundary().getExterior();
            this.interior = poly.getBoundary().getInteriors();
        }
    }

    public Ring getExterior() {
        return this.exterior;
    }

    public void setExterior(Ring exterior) {
        this.exterior = exterior;
    }

    public List<Ring> getInterior() {
        return this.interior;
    }

    public void setInterior(List<Ring> interior) {
        this.interior = interior;
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.coordinateReferenceSystem;
    }

    public void setCoordinateReferenceSystem(CoordinateReferenceSystem coordinateReferenceSystem) {
        this.coordinateReferenceSystem = coordinateReferenceSystem;
    }

    public SurfaceBoundary getSurfaceBoundary() {
        return new JTSSurfaceBoundary(this.coordinateReferenceSystem, this.exterior, this.interior);
    }

    public JTSPolygon getJTSPolygon() {
        List<Ring> inte;
        Ring out = this.exterior != null ? this.exterior : this.outerBoundaryIs;
        if (out != null) {
            ((JTSRing)out).setCoordinateReferenceSystem(this.coordinateReferenceSystem);
            for (Primitive primitive : out.getElements()) {
                if (!(primitive instanceof JTSCurve)) continue;
                JTSCurve curve = (JTSCurve)primitive;
                curve.setCoordinateReferenceSystem(this.coordinateReferenceSystem);
                for (CurveSegment curveSegment : curve.getSegments()) {
                    if (!(curveSegment instanceof JTSLineString)) continue;
                    JTSLineString line = (JTSLineString)curveSegment;
                    line.setCoordinateReferenceSystem(this.coordinateReferenceSystem);
                    PointArray pa = line.getControlPoints();
                    ArrayList<Position> newPositions = new ArrayList<Position>();
                    for (Position pos : pa.positions()) {
                        if (!(pos instanceof GeneralDirectPosition)) continue;
                        ((GeneralDirectPosition)pos).setCoordinateReferenceSystem(this.coordinateReferenceSystem);
                        newPositions.add(pos);
                    }
                    line.getControlPoints().clear();
                    line.getControlPoints().addAll(newPositions);
                }
            }
        }
        if ((inte = this.interior != null ? this.interior : this.innerBoundaryIs) != null) {
            for (Ring ring : inte) {
                ((JTSRing)ring).setCoordinateReferenceSystem(this.coordinateReferenceSystem);
                for (Primitive primitive : ring.getElements()) {
                    if (!(primitive instanceof JTSCurve)) continue;
                    JTSCurve curve = (JTSCurve)primitive;
                    curve.setCoordinateReferenceSystem(this.coordinateReferenceSystem);
                    for (CurveSegment cv : curve.getSegments()) {
                        if (!(cv instanceof JTSLineString)) continue;
                        JTSLineString line = (JTSLineString)cv;
                        line.setCoordinateReferenceSystem(this.coordinateReferenceSystem);
                        PointArray pa = line.getControlPoints();
                        ArrayList<Position> newPositions = new ArrayList<Position>();
                        for (Position pos : pa.positions()) {
                            if (!(pos instanceof GeneralDirectPosition)) continue;
                            ((GeneralDirectPosition)pos).setCoordinateReferenceSystem(this.coordinateReferenceSystem);
                            newPositions.add(pos);
                        }
                        line.getControlPoints().clear();
                        line.getControlPoints().addAll(newPositions);
                    }
                }
            }
        } else {
            inte = new ArrayList<Ring>();
        }
        JTSPolygon jTSPolygon = new JTSPolygon(new JTSSurfaceBoundary(this.coordinateReferenceSystem, out, inte));
        jTSPolygon.setCoordinateReferenceSystem(this.coordinateReferenceSystem);
        return jTSPolygon;
    }
}

