/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.internal.sql.table;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.Map;
import org.geotoolkit.internal.sql.Ordering;
import org.geotoolkit.internal.sql.table.ColumnOrParameter;
import org.geotoolkit.internal.sql.table.Query;
import org.geotoolkit.internal.sql.table.QueryType;
import org.geotoolkit.util.Utilities;

public final class Column
extends ColumnOrParameter {
    public final String table;
    public final String name;
    final Object defaultValue;
    private final Map<Column, Ordering> ordering;
    private EnumSet<QueryType> orderUsage;

    Column(String string, String string2) {
        this.ordering = null;
        this.table = string;
        this.name = string2;
        this.defaultValue = null;
    }

    Column(Query query, String string, String string2, Object object, QueryType[] queryTypeArray) {
        super(query, queryTypeArray);
        this.ordering = query.ordering;
        this.table = string.trim();
        this.name = string2.trim();
        this.defaultValue = object;
    }

    public void setFunction(String string, QueryType ... queryTypeArray) {
        this.setFunction(0, string, queryTypeArray);
    }

    public void setOrdering(Ordering ordering, QueryType ... queryTypeArray) {
        if (this.orderUsage == null) {
            this.orderUsage = EnumSet.noneOf(QueryType.class);
        }
        this.orderUsage.clear();
        this.orderUsage.addAll(Arrays.asList(queryTypeArray));
        this.ordering.put(this, ordering);
    }

    public Ordering getOrdering(QueryType queryType) {
        return this.orderUsage != null && this.orderUsage.contains((Object)queryType) ? this.ordering.get(this) : null;
    }

    final void appendName(StringBuilder stringBuilder, String string) {
        stringBuilder.append(string).append(this.name).append(string);
    }

    final void appendFullName(StringBuilder stringBuilder, String string) {
        stringBuilder.append(string).append(this.table).append(string).append('.').append(string).append(this.name).append(string);
    }

    @Override
    public int hashCode() {
        return this.name.hashCode() + super.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (super.equals(object)) {
            Column column = (Column)object;
            return Utilities.equals(this.table, column.table) && Utilities.equals(this.name, column.name) && Utilities.equals(this.defaultValue, column.defaultValue) && Utilities.equals(this.ordering, column.ordering);
        }
        return false;
    }

    public String toString() {
        return "Column[" + this.table + '.' + this.name + ']';
    }
}

