/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.internal.sql.table;

import java.sql.PreparedStatement;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.geotoolkit.internal.sql.table.Column;
import org.geotoolkit.internal.sql.table.ConfigurationKey;
import org.geotoolkit.internal.sql.table.Database;
import org.geotoolkit.internal.sql.table.LocalCache;
import org.geotoolkit.internal.sql.table.Parameter;
import org.geotoolkit.internal.sql.table.Query;
import org.geotoolkit.internal.sql.table.QueryType;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.resources.IndexedResourceBundle;
import org.geotoolkit.resources.Vocabulary;
import org.geotoolkit.util.ArgumentChecks;
import org.geotoolkit.util.Localized;
import org.geotoolkit.util.logging.Logging;
import org.geotoolkit.util.logging.PerformanceLevel;

public abstract class Table
implements Localized {
    protected final Query query;
    private QueryType type;
    private int modificationCount;
    volatile transient boolean canReuse;

    protected Table(Query query) {
        ArgumentChecks.ensureNonNull("query", query);
        this.query = query;
    }

    protected Table(Table table) {
        this.query = table.query;
    }

    protected abstract Table clone();

    public final Database getDatabase() throws IllegalStateException {
        Database database = this.query.database;
        if (database == null) {
            throw new IllegalStateException(this.errors().getString(154));
        }
        return database;
    }

    protected final String getProperty(ConfigurationKey configurationKey) {
        Database database = this.query.database;
        return database != null ? database.getProperty(configurationKey) : configurationKey.defaultValue;
    }

    protected final LocalCache getLocalCache() {
        return this.getDatabase().getLocalCache();
    }

    boolean wantsAutoGeneratedKeys() {
        return false;
    }

    private LocalCache.Stmt getStatement(LocalCache localCache, String string) throws SQLException {
        assert (Thread.holdsLock(localCache));
        LocalCache.Stmt stmt = localCache.prepareStatement(this, string);
        stmt.startTime = System.nanoTime();
        if (this.modificationCount != stmt.stamp) {
            QueryType queryType = this.type;
            this.configure(localCache, queryType, stmt.statement);
            stmt.stamp = this.modificationCount;
        }
        return stmt;
    }

    protected final LocalCache.Stmt getStatement(LocalCache localCache, QueryType queryType) throws SQLException {
        String string;
        switch (queryType) {
            default: {
                string = this.query.select(localCache, queryType);
                break;
            }
            case INSERT: {
                string = this.query.insert(localCache, queryType);
                break;
            }
            case DELETE: {
                string = this.query.delete(localCache, queryType);
                break;
            }
            case DELETE_ALL: {
                string = this.query.delete(localCache, queryType);
            }
        }
        this.type = queryType;
        return this.getStatement(localCache, string);
    }

    protected final LocalCache.Stmt getStatement(LocalCache localCache, QueryType queryType, Column column) throws SQLException {
        String string;
        switch (queryType) {
            case COUNT: {
                string = this.query.count(localCache, queryType, column);
                break;
            }
            default: {
                throw new IllegalArgumentException(this.errors().getString(73, "type", (Object)queryType));
            }
        }
        this.type = queryType;
        this.fireStateChanged();
        return this.getStatement(localCache, string);
    }

    protected final void release(LocalCache localCache, LocalCache.Stmt stmt) throws SQLException {
        assert (Thread.holdsLock(localCache));
        Database.release(localCache, stmt);
        Logger logger = this.getLogger();
        long l = System.nanoTime() - stmt.startTime;
        PerformanceLevel performanceLevel = PerformanceLevel.forDuration(l, TimeUnit.NANOSECONDS);
        if (logger.isLoggable(performanceLevel)) {
            Locale locale = this.getLocale();
            LogRecord logRecord = new LogRecord(performanceLevel, String.format(locale, "(%s: %.4f s) %s", Vocabulary.getResources(locale).getString(85), (double)l / 1.0E9, stmt));
            logRecord.setSourceClassName(this.getClass().getName());
            logRecord.setSourceMethodName(this.type.method);
            logRecord.setLoggerName(logger.getName());
            logger.log(logRecord);
        }
    }

    protected final void transactionBegin(LocalCache localCache) throws SQLException {
        this.getDatabase().transactionBegin(localCache);
    }

    protected final void transactionEnd(LocalCache localCache, boolean bl) throws SQLException {
        this.getDatabase().transactionEnd(localCache, bl);
    }

    protected void configure(LocalCache localCache, QueryType queryType, PreparedStatement preparedStatement) throws SQLException {
    }

    final Column getColumn(int n) {
        List<Column> list;
        if (n >= 1 && (list = this.query.getColumns(this.getQueryType())) != null && n <= list.size()) {
            return list.get(n - 1);
        }
        return null;
    }

    final QueryType getQueryType() {
        return this.type;
    }

    protected final int indexOf(Column column) throws SQLException {
        QueryType queryType = this.getQueryType();
        int n = column.indexOf(queryType);
        if (n > 0) {
            return n;
        }
        IndexedResourceBundle indexedResourceBundle = this.errors();
        throw new SQLDataException(indexedResourceBundle.getString(243, (Object)queryType) + ". " + indexedResourceBundle.getString(35, column.table, column.name));
    }

    protected final int indexOf(Parameter parameter) throws SQLException {
        QueryType queryType = this.getQueryType();
        int n = parameter.indexOf(queryType);
        if (n > 0) {
            return n;
        }
        throw new SQLDataException(this.errors().getString(243, (Object)queryType));
    }

    protected final Calendar getCalendar(LocalCache localCache) {
        Database database = this.getDatabase();
        Calendar calendar = database.getCalendar(localCache);
        assert (calendar.getTimeZone().equals(database.getTimeZone()));
        return calendar;
    }

    protected void fireStateChanged(String string) {
        this.fireStateChanged();
    }

    private void fireStateChanged() {
        Database database = this.query.database;
        do {
            if (database != null) {
                this.modificationCount = database.modificationCount.incrementAndGet();
                continue;
            }
            ++this.modificationCount;
        } while (this.modificationCount == -1);
    }

    final void unexpectedException(String string, Throwable throwable) {
        Logging.unexpectedException(this.getLogger(), this.getClass(), string, throwable);
    }

    protected final IndexedResourceBundle errors() {
        return Errors.getResources(this.getLocale());
    }

    protected final void log(String string, LogRecord logRecord) {
        Logger logger = this.getLogger();
        logRecord.setLoggerName(logger.getName());
        logRecord.setSourceClassName(this.getClass().getName());
        logRecord.setSourceMethodName(string);
        logger.log(logRecord);
    }

    public final Logger getLogger() {
        Logger logger;
        Database database = this.query.database;
        if (database != null && (logger = database.getLogger()) != null) {
            return logger;
        }
        return Logging.getLogger(this.getClass());
    }

    @Override
    public final Locale getLocale() {
        Database database = this.query.database;
        return database != null ? database.getLocale() : null;
    }

    public final void release() {
        this.canReuse = true;
    }
}

