/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.metadata;

import java.lang.reflect.Modifier;
import java.text.ParseException;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.tree.TreeModel;
import net.jcip.annotations.ThreadSafe;
import org.geotoolkit.gui.swing.tree.TreeTableNode;
import org.geotoolkit.metadata.MetadataStandard;
import org.geotoolkit.metadata.Pruner;
import org.geotoolkit.metadata.UnmodifiableMetadataException;
import org.geotoolkit.util.ComparisonMode;
import org.geotoolkit.util.LenientComparable;
import org.geotoolkit.util.logging.Logging;

@ThreadSafe
public abstract class AbstractMetadata
implements LenientComparable {
    protected static final Logger LOGGER = Logging.getLogger(AbstractMetadata.class);
    private transient int hashCode;
    private transient Map<String, Object> asMap;

    protected AbstractMetadata() {
    }

    protected AbstractMetadata(Object object) throws ClassCastException, UnmodifiableMetadataException {
        if (object != null) {
            this.getStandard().shallowCopy(object, this, true);
        }
    }

    public abstract MetadataStandard getStandard();

    public Class<?> getInterface() {
        return this.getStandard().getInterface(this.getClass());
    }

    boolean isModifiable() {
        return this.getStandard().isModifiable(this.getClass());
    }

    void invalidate() {
        assert (Thread.holdsLock(this));
        this.hashCode = 0;
    }

    public boolean isEmpty() {
        return Pruner.isEmpty(this, false);
    }

    void prune() {
        Pruner.isEmpty(this, true);
    }

    public synchronized Map<String, Object> asMap() {
        if (this.asMap == null) {
            this.asMap = this.getStandard().asMap(this);
        }
        return this.asMap;
    }

    public synchronized TreeTableNode asTreeTable() {
        return this.getStandard().asTreeTable(this);
    }

    public synchronized TreeModel asTree() {
        return this.getStandard().asTree(this);
    }

    public synchronized void parse(TreeModel treeModel) throws ParseException {
        this.getStandard().parse(treeModel, this);
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        int n;
        int n2;
        if (object == this) {
            return true;
        }
        if (comparisonMode == ComparisonMode.STRICT && (object == null || AbstractMetadata.getClass(object) != AbstractMetadata.getClass(this))) {
            return false;
        }
        MetadataStandard metadataStandard = this.getStandard();
        if (comparisonMode != ComparisonMode.STRICT && !this.getInterface().isInstance(object)) {
            return false;
        }
        if (object instanceof AbstractMetadata && (n2 = this.hashCode) != 0 && (n = ((AbstractMetadata)object).hashCode) != 0 && n2 != n) {
            return false;
        }
        return metadataStandard.shallowEquals(this, object, comparisonMode, false);
    }

    private static Class<?> getClass(Object object) {
        Class<?> clazz = object.getClass();
        while (!Modifier.isPublic(clazz.getModifiers()) && clazz.getName().startsWith("org.geotoolkit.metadata.iso.")) {
            clazz = clazz.getSuperclass();
        }
        return clazz;
    }

    @Override
    public final boolean equals(Object object) {
        return this.equals(object, ComparisonMode.STRICT);
    }

    public synchronized int hashCode() {
        int n = this.hashCode;
        if (n == 0) {
            n = this.getStandard().hashCode(this);
            if (!this.isModifiable()) {
                this.hashCode = n;
            }
        }
        return n;
    }

    public synchronized String toString() {
        return this.getStandard().toString(this);
    }
}

