/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.factory.wkt;

import java.io.IOException;
import java.net.URL;
import javax.sql.DataSource;
import org.geotoolkit.factory.Hints;
import org.geotoolkit.referencing.factory.wkt.CachingPostgisFactory;
import org.geotoolkit.referencing.factory.wkt.CachingPropertyFactory;
import org.geotoolkit.referencing.factory.wkt.PropertyAuthorityFactory;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.util.FactoryException;

public class AuthorityFactoryProvider {
    private final Hints hints;

    public AuthorityFactoryProvider() {
        this.hints = null;
    }

    public AuthorityFactoryProvider(Hints hints) {
        this.hints = hints != null ? hints.clone() : null;
    }

    public CRSAuthorityFactory createFromProperties(Citation citation, URL uRL) throws FactoryException {
        PropertyAuthorityFactory propertyAuthorityFactory;
        try {
            propertyAuthorityFactory = new PropertyAuthorityFactory(this.hints, uRL, citation);
        }
        catch (IOException iOException) {
            throw new FactoryException(iOException);
        }
        return new CachingPropertyFactory(propertyAuthorityFactory);
    }

    public CRSAuthorityFactory createFromPostGIS(DataSource dataSource) throws FactoryException {
        return new CachingPostgisFactory(this.hints, dataSource);
    }
}

