/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.geomatics.gml;

import com.vividsolutions.jts.geom.Coordinate;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBElement;
import org.geotoolkit.gml.xml.AbstractCurveSegment;
import org.geotoolkit.gml.xml.AbstractGeometry;
import org.geotoolkit.gml.xml.Curve;
import org.geotoolkit.gml.xml.DirectPosition;
import org.geotoolkit.gml.xml.LineString;
import org.geotoolkit.gml.xml.v321.AbstractCurveType;
import org.geotoolkit.gml.xml.v321.AbstractRingType;
import org.geotoolkit.gml.xml.v321.ArcByCenterPointType;
import org.geotoolkit.gml.xml.v321.ArcStringType;
import org.geotoolkit.gml.xml.v321.ArcType;
import org.geotoolkit.gml.xml.v321.CircleByCenterPointType;
import org.geotoolkit.gml.xml.v321.CircleType;
import org.geotoolkit.gml.xml.v321.CompositeCurveType;
import org.geotoolkit.gml.xml.v321.CurvePropertyType;
import org.geotoolkit.gml.xml.v321.DirectPositionType;
import org.geotoolkit.gml.xml.v321.GeodesicStringType;
import org.geotoolkit.gml.xml.v321.LineStringSegmentType;
import org.geotoolkit.gml.xml.v321.LinearRingType;
import org.geotoolkit.gml.xml.v321.OrientableCurveType;
import org.geotoolkit.gml.xml.v321.RingType;
import org.opengis.cite.geomatics.gml.CoordinateListFactory;
import org.opengis.cite.geomatics.gml.CurveSegmentType;
import org.opengis.cite.geomatics.gml.GmlUtils;

public class CurveCoordinateListFactory
implements CoordinateListFactory {
    public static final String ORIENT_NEG = "-";
    private static final Logger LOGR = Logger.getLogger(CurveCoordinateListFactory.class.getPackage().getName());
    public static Map<String, CurveSegmentType> segmentTypeMap = CurveCoordinateListFactory.loadSegmentTypeMap();

    private static Map<String, CurveSegmentType> loadSegmentTypeMap() {
        segmentTypeMap = new HashMap<String, CurveSegmentType>();
        segmentTypeMap.put(LineStringSegmentType.class.getName(), CurveSegmentType.LINE_STRING);
        segmentTypeMap.put(GeodesicStringType.class.getName(), CurveSegmentType.GEODESIC_STRING);
        segmentTypeMap.put(ArcByCenterPointType.class.getName(), CurveSegmentType.ARC_BY_CENTER);
        segmentTypeMap.put(CircleByCenterPointType.class.getName(), CurveSegmentType.ARC_BY_CENTER);
        segmentTypeMap.put(ArcStringType.class.getName(), CurveSegmentType.ARC_STRING);
        segmentTypeMap.put(ArcType.class.getName(), CurveSegmentType.ARC_STRING);
        segmentTypeMap.put(CircleType.class.getName(), CurveSegmentType.ARC_STRING);
        return segmentTypeMap;
    }

    @Override
    public List<Coordinate> createCoordinateList(AbstractGeometry gmlGeometry) {
        List<Coordinate> coordList = null;
        if (Curve.class.isInstance(gmlGeometry)) {
            coordList = this.getCoordinateList((Curve)Curve.class.cast(gmlGeometry));
        } else if (LineString.class.isInstance(gmlGeometry)) {
            coordList = this.getCoordinateList((LineString)LineString.class.cast(gmlGeometry));
        } else if (CompositeCurveType.class.isInstance(gmlGeometry)) {
            coordList = this.getCoordinateList((CompositeCurveType)CompositeCurveType.class.cast(gmlGeometry));
        } else if (OrientableCurveType.class.isInstance(gmlGeometry)) {
            coordList = this.getCoordinateList((OrientableCurveType)OrientableCurveType.class.cast(gmlGeometry));
        } else if (AbstractRingType.class.isInstance(gmlGeometry)) {
            try {
                coordList = this.getCoordinateList((AbstractRingType)AbstractRingType.class.cast(gmlGeometry));
            }
            catch (Exception x) {
                throw new RuntimeException("In GML ring: " + x.getMessage());
            }
        } else {
            throw new RuntimeException("Unsupported curve type: " + gmlGeometry.getClass().getName());
        }
        return coordList;
    }

    List<Coordinate> getCoordinateList(Curve curve) {
        ArrayList<Coordinate> coordList = new ArrayList<Coordinate>();
        List<? extends AbstractCurveSegment> segments = curve.getSegments().getAbstractCurveSegment();
        for (AbstractCurveSegment abstractCurveSegment : segments) {
            String className = abstractCurveSegment.getClass().getName();
            CurveSegmentType segmentType = segmentTypeMap.get(className);
            if (null == segmentType) {
                throw new RuntimeException("Unsupported curve segment type: " + className);
            }
            coordList.addAll(segmentType.getCoordinateList(abstractCurveSegment, curve.getCoordinateReferenceSystem()));
        }
        return coordList;
    }

    List<Coordinate> getCoordinateList(LineString lineString) {
        ArrayList<Coordinate> coords = new ArrayList<Coordinate>();
        if (null != lineString.getPosList()) {
            GmlUtils.extractCoordinatesFromPosList(lineString.getPosList().getValue(), lineString.getCoordinateDimension(), coords);
        } else {
            for (DirectPosition directPosition : lineString.getPos()) {
                coords.add(new Coordinate(directPosition.getOrdinate(0), directPosition.getOrdinate(1)));
            }
        }
        return coords;
    }

    List<Coordinate> getCoordinateList(CompositeCurveType compCurve) {
        ArrayList<Coordinate> coords = new ArrayList<Coordinate>();
        for (CurvePropertyType member : compCurve.getCurveMember()) {
            AbstractCurveType curveType = member.getAbstractCurve();
            if (null == curveType.getSrsName()) {
                curveType.setSrsName(compCurve.getSrsName());
            }
            coords.addAll(this.createCoordinateList(curveType));
        }
        return coords;
    }

    List<Coordinate> getCoordinateList(OrientableCurveType orientableCurve) {
        CurvePropertyType baseCurve = orientableCurve.getBaseCurve();
        List<Coordinate> coords = this.createCoordinateList(baseCurve.getAbstractCurve());
        if (orientableCurve.getOrientation().equals(ORIENT_NEG)) {
            Collections.reverse(coords);
        }
        return coords;
    }

    List<Coordinate> getCoordinateList(AbstractRingType ring) throws Exception {
        ArrayList<Coordinate> coords = new ArrayList<Coordinate>();
        if (LinearRingType.class.isInstance(ring)) {
            LinearRingType linearRing = (LinearRingType)LinearRingType.class.cast(ring);
            if (null != linearRing.getPosList()) {
                GmlUtils.extractCoordinatesFromPosList(linearRing.getPosList().getValue(), linearRing.getCoordinateDimension(), coords);
            } else {
                List<JAXBElement<?>> points = linearRing.getPosOrPointPropertyOrPointRep();
                for (JAXBElement<?> elem : points) {
                    DirectPositionType pos = (DirectPositionType)elem.getValue();
                    coords.add(new Coordinate(pos.getOrdinate(0), pos.getOrdinate(1)));
                }
            }
        } else {
            RingType gmlRing = (RingType)RingType.class.cast(ring);
            for (CurvePropertyType member : gmlRing.getCurveMember()) {
                AbstractCurveType curveType = null;
                if (null != member.getHref()) {
                    URI memberRef = URI.create(member.getHref());
                    AbstractGeometry geom = GmlUtils.unmarshalGMLGeometry(memberRef);
                    if (AbstractCurveType.class.isInstance(geom)) {
                        curveType = (AbstractCurveType)AbstractCurveType.class.cast(geom);
                    }
                } else {
                    curveType = member.getAbstractCurve();
                }
                if (LOGR.isLoggable(Level.FINE)) {
                    LOGR.fine("Processing ring member: " + curveType.getId());
                }
                if (null == curveType.getSrsName()) {
                    curveType.setSrsName(ring.getSrsName());
                }
                coords.addAll(this.createCoordinateList(curveType));
            }
        }
        return coords;
    }
}

