/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing;

import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.XmlElement;
import net.jcip.annotations.Immutable;
import org.geotoolkit.internal.referencing.NilReferencingObject;
import org.geotoolkit.referencing.AbstractIdentifiedObject;
import org.geotoolkit.util.ComparisonMode;
import org.geotoolkit.util.Utilities;
import org.opengis.metadata.extent.Extent;
import org.opengis.referencing.ReferenceSystem;
import org.opengis.util.InternationalString;

@Immutable
public class AbstractReferenceSystem
extends AbstractIdentifiedObject
implements ReferenceSystem {
    private static final long serialVersionUID = 3337659819553899435L;
    private static final String[] LOCALIZABLES = new String[]{"scope"};
    private final Extent domainOfValidity;
    @XmlElement(required=true)
    private final InternationalString scope;

    private AbstractReferenceSystem() {
        this(NilReferencingObject.INSTANCE);
    }

    public AbstractReferenceSystem(ReferenceSystem referenceSystem) {
        super(referenceSystem);
        this.domainOfValidity = referenceSystem.getDomainOfValidity();
        this.scope = referenceSystem.getScope();
    }

    public AbstractReferenceSystem(Map<String, ?> map) {
        this(map, new HashMap<String, Object>());
    }

    private AbstractReferenceSystem(Map<String, ?> map, Map<String, Object> map2) {
        super(map, map2, LOCALIZABLES);
        this.domainOfValidity = (Extent)map2.get("domainOfValidity");
        this.scope = (InternationalString)map2.get("scope");
    }

    @Override
    public Extent getDomainOfValidity() {
        return this.domainOfValidity;
    }

    @Override
    public InternationalString getScope() {
        return this.scope;
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (super.equals(object, comparisonMode)) {
            switch (comparisonMode) {
                case STRICT: {
                    AbstractReferenceSystem abstractReferenceSystem = (AbstractReferenceSystem)object;
                    return Utilities.equals((Object)this.domainOfValidity, (Object)abstractReferenceSystem.domainOfValidity) && Utilities.equals((Object)this.scope, (Object)abstractReferenceSystem.scope);
                }
                case BY_CONTRACT: {
                    ReferenceSystem referenceSystem = (ReferenceSystem)object;
                    return Utilities.deepEquals((Object)this.getDomainOfValidity(), (Object)referenceSystem.getDomainOfValidity(), (ComparisonMode)comparisonMode) && Utilities.deepEquals((Object)this.getScope(), (Object)referenceSystem.getScope(), (ComparisonMode)comparisonMode);
                }
            }
            return true;
        }
        return false;
    }
}

