/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.crs;

import java.util.Map;
import net.jcip.annotations.Immutable;
import org.geotoolkit.internal.referencing.NilReferencingObject;
import org.geotoolkit.io.wkt.Formatter;
import org.geotoolkit.referencing.crs.AbstractCRS;
import org.geotoolkit.util.ArgumentChecks;
import org.geotoolkit.util.ComparisonMode;
import org.geotoolkit.util.Utilities;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.datum.Datum;

@Immutable
public class AbstractSingleCRS
extends AbstractCRS
implements SingleCRS {
    private static final long serialVersionUID = 1815712797774273L;
    private Datum datum;

    private AbstractSingleCRS() {
        this(NilReferencingObject.INSTANCE);
    }

    public AbstractSingleCRS(SingleCRS singleCRS) {
        super(singleCRS);
        this.datum = singleCRS.getDatum();
    }

    public AbstractSingleCRS(Map<String, ?> map, Datum datum, CoordinateSystem coordinateSystem) {
        super(map, coordinateSystem);
        this.datum = datum;
        ArgumentChecks.ensureNonNull((String)"datum", (Object)datum);
    }

    @Override
    public Datum getDatum() {
        return this.datum;
    }

    final void setDatum(Datum datum) {
        if (this.datum != NilReferencingObject.INSTANCE) {
            throw new IllegalStateException();
        }
        ArgumentChecks.ensureNonNull((String)"datum", (Object)datum);
        this.datum = datum;
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (super.equals(object, comparisonMode)) {
            switch (comparisonMode) {
                case STRICT: {
                    AbstractSingleCRS abstractSingleCRS = (AbstractSingleCRS)object;
                    return Utilities.equals((Object)this.datum, (Object)abstractSingleCRS.datum);
                }
            }
            SingleCRS singleCRS = (SingleCRS)object;
            return Utilities.deepEquals((Object)this.getDatum(), (Object)singleCRS.getDatum(), (ComparisonMode)comparisonMode);
        }
        return false;
    }

    @Override
    protected int computeHashCode() {
        return Utilities.hash((Object)this.datum, (int)super.computeHashCode());
    }

    @Override
    final void formatDefaultWKT(Formatter formatter) {
        formatter.append(this.datum);
        super.formatDefaultWKT(formatter);
    }
}

