/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.jcip.annotations.ThreadSafe;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.resources.Locales;
import org.geotoolkit.util.AbstractInternationalString;
import org.geotoolkit.util.Utilities;
import org.geotoolkit.util.collection.XCollections;
import org.opengis.util.InternationalString;

@ThreadSafe
public class DefaultInternationalString
extends AbstractInternationalString
implements Serializable {
    private static final long serialVersionUID = 5760033376627376938L;
    private Map<Locale, String> localeMap;
    private transient Set<Locale> localeSet;

    public DefaultInternationalString() {
        this.localeMap = Collections.emptyMap();
    }

    public DefaultInternationalString(String string) {
        this.localeMap = string != null ? Collections.singletonMap(null, string) : Collections.emptyMap();
    }

    public DefaultInternationalString(Map<Locale, String> map) {
        if (XCollections.isNullOrEmpty(map)) {
            this.localeMap = Collections.emptyMap();
        } else {
            Iterator<Map.Entry<Locale, String>> iterator = map.entrySet().iterator();
            Map.Entry<Locale, String> entry = iterator.next();
            this.localeMap = !iterator.hasNext() ? Collections.singletonMap(entry.getKey(), entry.getValue()) : new LinkedHashMap<Locale, String>(map);
        }
    }

    public synchronized void add(Locale locale, String string) throws IllegalArgumentException {
        if (string != null) {
            switch (this.localeMap.size()) {
                case 0: {
                    this.localeMap = Collections.singletonMap(locale, string);
                    this.localeSet = null;
                    this.defaultValue = null;
                    return;
                }
                case 1: {
                    this.localeMap = new LinkedHashMap<Locale, String>(this.localeMap);
                    this.localeSet = null;
                }
            }
            String string2 = this.localeMap.get(locale);
            if (string2 != null) {
                if (string.equals(string2)) {
                    return;
                }
                throw new IllegalArgumentException(Errors.format(245, locale));
            }
            this.localeMap.put(locale, string);
            this.defaultValue = null;
        }
    }

    public boolean add(String string, String string2, String string3) throws IllegalArgumentException {
        if (string2.startsWith(string)) {
            Locale locale = null;
            int n = string.length();
            if (string2.length() != n) {
                if (string2.charAt(n) == '_') {
                    locale = Locales.parse(string2.substring(n + 1));
                } else {
                    return false;
                }
            }
            this.add(locale, string3);
            return true;
        }
        return false;
    }

    public synchronized Set<Locale> getLocales() {
        Set<Locale> set = this.localeSet;
        if (set == null) {
            set = this.localeMap.keySet();
            if (this.localeMap instanceof HashMap) {
                set = Collections.unmodifiableSet(set);
            }
            this.localeSet = set;
        }
        return set;
    }

    private String getString(Locale locale) {
        while (locale != null) {
            String string = this.localeMap.get(locale);
            if (string != null) {
                return string;
            }
            String string2 = locale.getLanguage();
            String string3 = locale.getCountry();
            String string4 = locale.getVariant();
            if (!string4.isEmpty()) {
                locale = new Locale(string2, string3);
                continue;
            }
            if (string3.isEmpty()) break;
            locale = new Locale(string2);
        }
        return null;
    }

    @Override
    public synchronized String toString(Locale locale) {
        String string = this.getString(locale);
        if (string == null && (string = this.localeMap.get(null)) == null) {
            Locale locale2 = Locale.UK;
            if (locale != locale2 && (string = this.getString(locale2)) != null) {
                return string;
            }
            locale2 = Locale.getDefault();
            if (locale != locale2 && locale2 != Locale.UK && (string = this.getString(locale2)) != null) {
                return string;
            }
            Iterator<String> iterator = this.localeMap.values().iterator();
            if (iterator.hasNext()) {
                string = iterator.next();
            }
        }
        return string;
    }

    public synchronized boolean isSubsetOf(Object object) {
        if (object instanceof InternationalString) {
            InternationalString internationalString = (InternationalString)object;
            for (Map.Entry<Locale, String> entry : this.localeMap.entrySet()) {
                Locale locale = entry.getKey();
                String string = entry.getValue();
                if (string.equals(internationalString.toString(locale))) continue;
                return false;
            }
        } else if (object instanceof CharSequence) {
            String string = object.toString();
            for (String string2 : this.localeMap.values()) {
                if (string2.equals(string)) continue;
                return false;
            }
        } else {
            if (object instanceof Map) {
                Map map = (Map)object;
                return map.entrySet().containsAll(this.localeMap.entrySet());
            }
            return false;
        }
        return true;
    }

    public boolean equals(Object object) {
        if (object != null && object.getClass() == this.getClass()) {
            DefaultInternationalString defaultInternationalString = (DefaultInternationalString)object;
            return Utilities.equals(this.localeMap, defaultInternationalString.localeMap);
        }
        return false;
    }

    public synchronized int hashCode() {
        return 0x8C44C32A ^ ((Object)this.localeMap).hashCode();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = this.localeMap.size();
        if (n == 0) {
            return;
        }
        Map.Entry[] entryArray = new Map.Entry[n];
        entryArray = this.localeMap.entrySet().toArray(entryArray);
        if (n == 1) {
            Map.Entry entry = entryArray[0];
            this.localeMap = Collections.singletonMap(Locales.unique((Locale)entry.getKey()), entry.getValue());
        } else {
            this.localeMap.clear();
            for (int i = 0; i < entryArray.length; ++i) {
                Map.Entry entry = entryArray[i];
                this.localeMap.put(Locales.unique((Locale)entry.getKey()), (String)entry.getValue());
            }
        }
    }
}

