/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.metadata.iso.acquisition;

import java.util.Date;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import net.jcip.annotations.ThreadSafe;
import org.geotoolkit.metadata.iso.MetadataEntity;
import org.opengis.metadata.acquisition.RequestedDate;

@ThreadSafe
@XmlType(name="MI_RequestedDate_Type", propOrder={"requestedDateOfCollection", "latestAcceptableDate"})
@XmlRootElement(name="MI_RequestedDate")
public class DefaultRequestedDate
extends MetadataEntity
implements RequestedDate {
    private static final long serialVersionUID = -8884795189934200802L;
    private long requestedDateOfCollection;
    private long latestAcceptableDate;

    public DefaultRequestedDate() {
        this.requestedDateOfCollection = Long.MIN_VALUE;
        this.latestAcceptableDate = Long.MIN_VALUE;
    }

    public DefaultRequestedDate(RequestedDate requestedDate) {
        super(requestedDate);
        if (requestedDate != null) {
            if (this.requestedDateOfCollection == 0L && requestedDate.getRequestedDateOfCollection() == null) {
                this.requestedDateOfCollection = Long.MIN_VALUE;
            }
            if (this.latestAcceptableDate == 0L && requestedDate.getLatestAcceptableDate() == null) {
                this.latestAcceptableDate = Long.MIN_VALUE;
            }
        }
    }

    public static DefaultRequestedDate castOrCopy(RequestedDate requestedDate) {
        return requestedDate == null || requestedDate instanceof DefaultRequestedDate ? (DefaultRequestedDate)requestedDate : new DefaultRequestedDate(requestedDate);
    }

    @Override
    @XmlElement(name="requestedDateOfCollection", required=true)
    public synchronized Date getRequestedDateOfCollection() {
        long l = this.requestedDateOfCollection;
        return l != Long.MIN_VALUE ? new Date(l) : null;
    }

    public synchronized void setRequestedDateOfCollection(Date date) {
        this.checkWritePermission();
        this.requestedDateOfCollection = date != null ? date.getTime() : Long.MIN_VALUE;
    }

    @Override
    @XmlElement(name="latestAcceptableDate", required=true)
    public synchronized Date getLatestAcceptableDate() {
        long l = this.latestAcceptableDate;
        return l != Long.MIN_VALUE ? new Date(l) : null;
    }

    public synchronized void setLatestAcceptableDate(Date date) {
        this.checkWritePermission();
        this.latestAcceptableDate = date != null ? date.getTime() : Long.MIN_VALUE;
    }
}

