/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.geometry.jts.coordinatesequence;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.impl.PackedCoordinateSequence;

public class LiteCoordinateSequence
extends PackedCoordinateSequence {
    private double[] coords;
    private int size;

    public LiteCoordinateSequence(double[] coords) {
        this.dimension = 2;
        if (coords.length % this.dimension != 0) {
            throw new IllegalArgumentException("Packed array does not contain an integral number of coordinates");
        }
        this.coords = coords;
        this.size = coords.length / this.dimension;
    }

    public LiteCoordinateSequence(float[] coordinates) {
        this.coords = new double[coordinates.length];
        this.dimension = 2;
        this.size = this.coords.length / this.dimension;
        System.arraycopy(coordinates, 0, this.coords, 0, coordinates.length);
    }

    public LiteCoordinateSequence(Coordinate[] coordinates) {
        if (coordinates == null) {
            coordinates = new Coordinate[]{};
        }
        this.dimension = 2;
        this.coords = new double[coordinates.length * this.dimension];
        for (int i = 0; i < coordinates.length; ++i) {
            this.coords[i * this.dimension] = coordinates[i].x;
            this.coords[i * this.dimension + 1] = coordinates[i].y;
        }
        this.size = coordinates.length;
    }

    public LiteCoordinateSequence(int size, int dimension) {
        if (dimension != 2) {
            throw new IllegalArgumentException("This type of sequence is always 2 dimensional");
        }
        this.dimension = 2;
        this.coords = new double[size * this.dimension];
        this.size = this.coords.length / dimension;
    }

    public LiteCoordinateSequence(LiteCoordinateSequence seq) {
        this.dimension = seq.dimension;
        this.size = seq.size;
        double[] orig = seq.getArray();
        this.coords = new double[orig.length];
        System.arraycopy(orig, 0, this.coords, 0, this.coords.length);
    }

    public Coordinate getCoordinateInternal(int i) {
        double x = this.coords[i * this.dimension];
        double y = this.coords[i * this.dimension + 1];
        double z = this.dimension == 2 ? Double.NaN : this.coords[i * this.dimension + 2];
        return new Coordinate(x, y, z);
    }

    public int size() {
        return this.size;
    }

    public Object clone() {
        double[] clone = new double[this.coords.length];
        System.arraycopy(this.coords, 0, clone, 0, this.coords.length);
        return new LiteCoordinateSequence(clone);
    }

    public double getOrdinate(int index, int ordinate) {
        return this.coords[index * this.dimension + ordinate];
    }

    public double getX(int index) {
        return this.coords[index * this.dimension];
    }

    public double getY(int index) {
        return this.coords[index * this.dimension + 1];
    }

    public void setOrdinate(int index, int ordinate, double value) {
        this.coordRef = null;
        this.coords[index * this.dimension + ordinate] = value;
    }

    public Envelope expandEnvelope(Envelope env) {
        double miny;
        double minx;
        double maxx = minx = this.coords[0];
        double maxy = miny = this.coords[1];
        for (int i = 0; i < this.coords.length; i += this.dimension) {
            double x = this.coords[i];
            double y = this.coords[i + 1];
            if (x < minx) {
                minx = x;
            } else if (x > maxx) {
                maxx = x;
            }
            if (y < miny) {
                miny = y;
                continue;
            }
            if (!(y > maxy)) continue;
            maxy = y;
        }
        env.expandToInclude(minx, miny);
        env.expandToInclude(maxx, maxy);
        return env;
    }

    public double[] getArray() {
        return this.coords;
    }

    public void setArray(double[] coords2) {
        this.coords = coords2;
        this.size = this.coords.length / this.dimension;
        this.coordRef = null;
    }

    public double[] getXYArray() {
        if (this.dimension == 2) {
            return this.coords;
        }
        int n = this.size();
        double[] result = new double[n * 2];
        for (int t = 0; t < n; ++t) {
            result[t * 2] = this.getOrdinate(t, 0);
            result[t * 2 + 1] = this.getOrdinate(t, 1);
        }
        return result;
    }
}

