/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.datum;

import java.util.Collections;
import java.util.Map;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import net.jcip.annotations.Immutable;
import org.geotoolkit.internal.referencing.NilReferencingObject;
import org.geotoolkit.io.wkt.Formatter;
import org.geotoolkit.referencing.datum.AbstractDatum;
import org.geotoolkit.util.ArgumentChecks;
import org.geotoolkit.util.ComparisonMode;
import org.geotoolkit.util.Utilities;
import org.opengis.referencing.datum.ImageDatum;
import org.opengis.referencing.datum.PixelInCell;

@Immutable
@XmlType(name="ImageDatumType")
@XmlRootElement(name="ImageDatum")
public class DefaultImageDatum
extends AbstractDatum
implements ImageDatum {
    private static final long serialVersionUID = -4304193511244150936L;
    private final PixelInCell pixelInCell;

    private DefaultImageDatum() {
        this(NilReferencingObject.INSTANCE);
    }

    public DefaultImageDatum(ImageDatum imageDatum) {
        super(imageDatum);
        this.pixelInCell = imageDatum.getPixelInCell();
    }

    public DefaultImageDatum(String string, PixelInCell pixelInCell) {
        this(Collections.singletonMap("name", string), pixelInCell);
    }

    public DefaultImageDatum(Map<String, ?> map, PixelInCell pixelInCell) {
        super(map);
        this.pixelInCell = pixelInCell;
        ArgumentChecks.ensureNonNull((String)"pixelInCell", (Object)pixelInCell);
    }

    public static DefaultImageDatum castOrCopy(ImageDatum imageDatum) {
        return imageDatum == null || imageDatum instanceof DefaultImageDatum ? (DefaultImageDatum)imageDatum : new DefaultImageDatum(imageDatum);
    }

    @Override
    public PixelInCell getPixelInCell() {
        return this.pixelInCell;
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, comparisonMode)) {
            switch (comparisonMode) {
                case STRICT: {
                    DefaultImageDatum defaultImageDatum = (DefaultImageDatum)object;
                    return Utilities.equals((Object)this.pixelInCell, (Object)defaultImageDatum.pixelInCell);
                }
            }
            ImageDatum imageDatum = (ImageDatum)object;
            return Utilities.equals((Object)this.getPixelInCell(), (Object)imageDatum.getPixelInCell());
        }
        return false;
    }

    @Override
    protected int computeHashCode() {
        return Utilities.hash((Object)this.pixelInCell, (int)super.computeHashCode());
    }

    @Override
    public String formatWKT(Formatter formatter) {
        super.formatWKT(formatter);
        formatter.append(this.pixelInCell);
        formatter.setInvalidWKT(ImageDatum.class);
        return "IMAGE_DATUM";
    }
}

