/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation;

import java.util.AbstractSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import net.jcip.annotations.Immutable;
import org.geotoolkit.referencing.operation.MathTransformProvider;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.SingleOperation;

@Immutable
final class OperationMethodSet
extends AbstractSet<OperationMethod> {
    private final MathTransformProvider[] providers;
    private final Class<? extends SingleOperation> type;
    private int size = -1;

    public OperationMethodSet(MathTransformProvider[] mathTransformProviderArray, Class<? extends SingleOperation> clazz) {
        this.providers = mathTransformProviderArray;
        this.type = clazz;
        if (clazz == null) {
            this.size = mathTransformProviderArray.length;
        }
    }

    @Override
    public Iterator<OperationMethod> iterator() {
        return new Iter(this.providers, this.type);
    }

    @Override
    public int size() {
        if (this.size < 0) {
            int n = 0;
            Iterator<OperationMethod> iterator = this.iterator();
            while (iterator.hasNext()) {
                iterator.next();
                ++n;
            }
            this.size = n;
        }
        return this.size;
    }

    private static class Iter
    implements Iterator<OperationMethod> {
        private final MathTransformProvider[] providers;
        private final Class<? extends SingleOperation> type;
        private int cursor;

        Iter(MathTransformProvider[] mathTransformProviderArray, Class<? extends SingleOperation> clazz) {
            this.providers = mathTransformProviderArray;
            this.type = clazz;
            this.skip();
        }

        private void skip() {
            if (this.type != null) {
                Class<? extends SingleOperation> clazz;
                while (this.cursor < this.providers.length && (clazz = this.providers[this.cursor].getOperationType()) != null && !this.type.isAssignableFrom(clazz)) {
                    ++this.cursor;
                }
            }
        }

        @Override
        public boolean hasNext() {
            return this.cursor < this.providers.length;
        }

        @Override
        public OperationMethod next() {
            int n;
            if ((n = this.cursor++) < this.providers.length) {
                this.skip();
                return this.providers[n];
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }
    }
}

