/*
 * Decompiled with CFR 0.152.
 */
package com.occamlab.te;

import com.occamlab.te.Generator;
import com.occamlab.te.SetupOptions;
import com.occamlab.te.index.Index;
import com.occamlab.te.index.SuiteEntry;
import java.io.File;

public class ListSuites {
    public static void main(String[] args) throws Exception {
        SetupOptions setupOpts = new SetupOptions();
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].startsWith("-source=")) continue;
            File scriptsDir = new File(SetupOptions.getBaseConfigDirectory(), "scripts");
            File f = new File(scriptsDir, args[i].substring(8));
            if (f.exists()) {
                setupOpts.addSource(f);
                continue;
            }
            System.out.println("Error: Can't find CTL script(s) at " + f.getAbsolutePath());
            return;
        }
        Index index = Generator.generateXsl(setupOpts);
        for (String suiteId : index.getSuiteKeys()) {
            String link;
            SuiteEntry suite = index.getSuite(suiteId);
            System.out.print("Suite " + suite.getPrefix() + ":" + suite.getLocalName());
            System.out.println(" (" + suiteId + ")");
            System.out.println(suite.getTitle());
            String desc = suite.getDescription();
            if (desc != null) {
                System.out.println(desc);
            }
            if ((link = suite.getLink()) != null) {
                System.out.println("See " + link);
            }
            System.out.println();
        }
    }
}

