/*
 * Decompiled with CFR 0.152.
 */
package com.occamlab.te.spi.executors.testng;

import java.time.Duration;
import java.util.Date;
import java.util.Map;
import org.testng.ISuite;
import org.testng.ISuiteResult;
import org.testng.ITestContext;

public class TestRunSummary {
    private int totalPassed;
    private int totalFailed;
    private int totalSkipped;
    private Duration totalDuration;

    public TestRunSummary(ISuite suite) {
        this.summarizeResults(suite.getResults());
    }

    public int getTotalPassed() {
        return this.totalPassed;
    }

    public int getTotalFailed() {
        return this.totalFailed;
    }

    public int getTotalSkipped() {
        return this.totalSkipped;
    }

    public String getTotalDuration() {
        return this.totalDuration.toString();
    }

    void summarizeResults(Map<String, ISuiteResult> results) {
        Date earliestStartDate = new Date();
        Date latestEndDate = new Date();
        for (Map.Entry<String, ISuiteResult> entry : results.entrySet()) {
            Date endDate;
            ITestContext testContext = entry.getValue().getTestContext();
            this.totalPassed += testContext.getPassedTests().size();
            this.totalFailed += testContext.getFailedTests().size();
            this.totalSkipped += testContext.getSkippedTests().size();
            Date startDate = testContext.getStartDate();
            if (earliestStartDate.after(startDate)) {
                earliestStartDate = startDate;
            }
            if (!latestEndDate.before(endDate = testContext.getEndDate())) continue;
            latestEndDate = endDate != null ? endDate : startDate;
        }
        this.totalDuration = Duration.between(earliestStartDate.toInstant(), latestEndDate.toInstant());
    }
}

