/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom.prep;

import com.vividsolutions.jts.algorithm.locate.IndexedPointInAreaLocator;
import com.vividsolutions.jts.algorithm.locate.PointOnGeometryLocator;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.Polygonal;
import com.vividsolutions.jts.geom.prep.BasicPreparedGeometry;
import com.vividsolutions.jts.geom.prep.PreparedPolygonContains;
import com.vividsolutions.jts.geom.prep.PreparedPolygonContainsProperly;
import com.vividsolutions.jts.geom.prep.PreparedPolygonCovers;
import com.vividsolutions.jts.geom.prep.PreparedPolygonIntersects;
import com.vividsolutions.jts.noding.FastSegmentSetIntersectionFinder;
import com.vividsolutions.jts.noding.SegmentStringUtil;
import com.vividsolutions.jts.operation.predicate.RectangleContains;
import com.vividsolutions.jts.operation.predicate.RectangleIntersects;

public class PreparedPolygon
extends BasicPreparedGeometry {
    private boolean isRectangle = this.getGeometry().isRectangle();
    private FastSegmentSetIntersectionFinder segIntFinder = null;
    private PointOnGeometryLocator pia = null;

    public PreparedPolygon(Polygonal poly) {
        super((Geometry)((Object)poly));
    }

    public synchronized FastSegmentSetIntersectionFinder getIntersectionFinder() {
        if (this.segIntFinder == null) {
            this.segIntFinder = new FastSegmentSetIntersectionFinder(SegmentStringUtil.extractSegmentStrings(this.getGeometry()));
        }
        return this.segIntFinder;
    }

    public synchronized PointOnGeometryLocator getPointLocator() {
        if (this.pia == null) {
            this.pia = new IndexedPointInAreaLocator(this.getGeometry());
        }
        return this.pia;
    }

    public boolean intersects(Geometry g2) {
        if (!this.envelopesIntersect(g2)) {
            return false;
        }
        if (this.isRectangle) {
            return RectangleIntersects.intersects((Polygon)this.getGeometry(), g2);
        }
        return PreparedPolygonIntersects.intersects(this, g2);
    }

    public boolean contains(Geometry g2) {
        if (!this.envelopeCovers(g2)) {
            return false;
        }
        if (this.isRectangle) {
            return RectangleContains.contains((Polygon)this.getGeometry(), g2);
        }
        return PreparedPolygonContains.contains(this, g2);
    }

    public boolean containsProperly(Geometry g2) {
        if (!this.envelopeCovers(g2)) {
            return false;
        }
        return PreparedPolygonContainsProperly.containsProperly(this, g2);
    }

    public boolean covers(Geometry g2) {
        if (!this.envelopeCovers(g2)) {
            return false;
        }
        if (this.isRectangle) {
            return true;
        }
        return PreparedPolygonCovers.covers(this, g2);
    }
}

