/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.math;

public class Matrix {
    private static void swapRows(double[][] m3, int i, int j) {
        if (i == j) {
            return;
        }
        for (int col = 0; col < m3[0].length; ++col) {
            double temp = m3[i][col];
            m3[i][col] = m3[j][col];
            m3[j][col] = temp;
        }
    }

    private static void swapRows(double[] m3, int i, int j) {
        if (i == j) {
            return;
        }
        double temp = m3[i];
        m3[i] = m3[j];
        m3[j] = temp;
    }

    public static double[] solve(double[][] a, double[] b) {
        int n = b.length;
        if (a.length != n || a[0].length != n) {
            throw new IllegalArgumentException("Matrix A is incorrectly sized");
        }
        for (int i = 0; i < n; ++i) {
            int j;
            int maxElementRow = i;
            for (j = i + 1; j < n; ++j) {
                if (!(Math.abs(a[j][i]) > Math.abs(a[maxElementRow][i]))) continue;
                maxElementRow = j;
            }
            if (a[maxElementRow][i] == 0.0) {
                return null;
            }
            Matrix.swapRows(a, i, maxElementRow);
            Matrix.swapRows(b, i, maxElementRow);
            j = i + 1;
            while (j < n) {
                double rowFactor = a[j][i] / a[i][i];
                for (int k = n - 1; k >= i; --k) {
                    double[] dArray = a[j];
                    int n2 = k;
                    dArray[n2] = dArray[n2] - a[i][k] * rowFactor;
                }
                int n3 = j++;
                b[n3] = b[n3] - b[i] * rowFactor;
            }
        }
        double[] solution = new double[n];
        for (int j = n - 1; j >= 0; --j) {
            double t = 0.0;
            for (int k = j + 1; k < n; ++k) {
                t += a[j][k] * solution[k];
            }
            solution[j] = (b[j] - t) / a[j][j];
        }
        return solution;
    }
}

