/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.lang.reflect.Modifier;
import java.util.List;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.loader.ClassInspector;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.JavaToSQLValueNode;
import org.apache.derby.impl.sql.compile.JavaValueNode;
import org.apache.derby.impl.sql.compile.MethodCallNode;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.SQLToJavaValueNode;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.ValueNode;

public class NonStaticMethodCallNode
extends MethodCallNode {
    JavaValueNode receiver;
    private boolean isStatic;

    public void init(Object object, Object object2) throws StandardException {
        super.init(object);
        this.receiver = object2 instanceof JavaToSQLValueNode ? ((JavaToSQLValueNode)object2).getJavaValueNode() : (JavaValueNode)this.getNodeFactory().getNode(28, object2, this.getContextManager());
    }

    public JavaValueNode bindExpression(FromList fromList, SubqueryList subqueryList, List list) throws StandardException {
        Object object;
        if (this.receiver instanceof SQLToJavaValueNode && ((ValueNode)(object = ((SQLToJavaValueNode)this.receiver).getSQLValueNode())).requiresTypeFromContext() && ((ValueNode)object).getTypeServices() == null) {
            throw StandardException.newException("42X54", this.methodName);
        }
        this.bindParameters(fromList, subqueryList, list);
        this.receiver = this.receiver.bindExpression(fromList, subqueryList, list);
        object = this.receiver.getJSQLType().getSQLType().getTypeId().getSQLTypeName();
        if (((String)object).equals("BLOB") || ((String)object).equals("CLOB") || ((String)object).equals("NCLOB")) {
            throw StandardException.newException("XJ082.U");
        }
        this.javaClassName = this.receiver.getJavaTypeName();
        if (ClassInspector.primitiveType(this.javaClassName)) {
            throw StandardException.newException("42X52", (Object)this.methodName, (Object)this.javaClassName);
        }
        this.resolveMethodCall(this.javaClassName, false);
        this.isStatic = Modifier.isStatic(this.method.getModifiers());
        return this;
    }

    public boolean categorize(JBitSet jBitSet, boolean bl) throws StandardException {
        if (bl) {
            return false;
        }
        boolean bl2 = true;
        boolean bl3 = bl2 = bl2 && super.categorize(jBitSet, bl);
        if (this.receiver != null) {
            bl2 = bl2 && this.receiver.categorize(jBitSet, bl);
        }
        return bl2;
    }

    protected int getOrderableVariantType() throws StandardException {
        int n;
        int n2 = this.receiver.getOrderableVariantType();
        if (n2 > 1 && this.receiver.getJavaTypeName().equals("org.apache.derby.iapi.db.TriggerExecutionContext")) {
            n2 = 1;
        }
        if (n2 < (n = super.getOrderableVariantType())) {
            return n2;
        }
        return n;
    }

    public JavaValueNode remapColumnReferencesToExpressions() throws StandardException {
        if (this.receiver != null) {
            this.receiver.remapColumnReferencesToExpressions();
        }
        return super.remapColumnReferencesToExpressions();
    }

    public void printSubNodes(int n) {
    }

    public void preprocess(int n, FromList fromList, SubqueryList subqueryList, PredicateList predicateList) throws StandardException {
        super.preprocess(n, fromList, subqueryList, predicateList);
        this.receiver.preprocess(n, fromList, subqueryList, predicateList);
    }

    public void generateExpression(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        Class<?> clazz;
        boolean bl = false;
        if (!this.valueReturnedToSQLDomain() && !this.returnValueDiscarded() && this.generateReceiver(expressionClassBuilder, methodBuilder, this.receiver)) {
            bl = true;
            methodBuilder.conditionalIfNull();
            methodBuilder.pushNull(this.getJavaTypeName());
            methodBuilder.startElseCode();
        }
        short s2 = (clazz = this.method.getDeclaringClass()).isInterface() ? (short)185 : (this.isStatic ? (short)184 : 182);
        this.getReceiverExpression(expressionClassBuilder, methodBuilder, this.receiver);
        if (this.isStatic) {
            methodBuilder.endStatement();
        }
        int n = this.generateParameters(expressionClassBuilder, methodBuilder);
        methodBuilder.callMethod(s2, clazz.getName(), this.methodName, this.getJavaTypeName(), n);
        if (bl) {
            methodBuilder.completeConditional();
        }
    }

    protected boolean generateReceiver(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        if (this.isStatic) {
            return false;
        }
        return this.generateReceiver(expressionClassBuilder, methodBuilder, this.receiver);
    }

    void acceptChildren(Visitor visitor) throws StandardException {
        super.acceptChildren(visitor);
        if (this.receiver != null) {
            this.receiver = (JavaValueNode)this.receiver.accept(visitor);
        }
    }
}

