/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.graph.compose;

import java.util.Iterator;
import java.util.Set;
import org.apache.jena.JenaRuntime;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.GraphStatisticsHandler;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.graph.compose.Polyadic;
import org.apache.jena.graph.impl.SimpleEventManager;
import org.apache.jena.util.CollectionFactory;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.NullIterator;

public class MultiUnion
extends Polyadic {
    private boolean optimising = JenaRuntime.getSystemProperty("jena.union.optimise", "yes").equals("yes");

    public MultiUnion() {
    }

    public MultiUnion(Graph[] graphs) {
        super(graphs);
    }

    public MultiUnion(Iterator<Graph> graphs) {
        super(graphs);
    }

    private boolean optimiseOne() {
        return this.optimising && this.m_subGraphs.size() == 1;
    }

    @Override
    protected GraphStatisticsHandler createStatisticsHandler() {
        return new MultiUnionStatisticsHandler(this);
    }

    @Override
    public void performAdd(Triple t) {
        this.getRequiredBaseGraph().add(t);
    }

    @Override
    public void performDelete(Triple t) {
        this.getRequiredBaseGraph().delete(t);
    }

    @Override
    public boolean graphBaseContains(Triple t) {
        for (Graph m_subGraph : this.m_subGraphs) {
            if (!m_subGraph.contains(t)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ExtendedIterator<Triple> graphBaseFind(Triple t) {
        ExtendedIterator<Triple> found = this.optimiseOne() ? this.singleGraphFind(t) : this.multiGraphFind(t);
        return SimpleEventManager.notifyingRemove(this, found);
    }

    private ExtendedIterator<Triple> singleGraphFind(Triple t) {
        return ((Graph)this.m_subGraphs.get(0)).find(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExtendedIterator<Triple> multiGraphFind(Triple t) {
        Set<Triple> seen = CollectionFactory.createHashedSet();
        ExtendedIterator<Object> result = NullIterator.instance();
        boolean finished = false;
        try {
            for (Graph m_subGraph : this.m_subGraphs) {
                ExtendedIterator<Triple> newTriples = MultiUnion.recording(MultiUnion.rejecting(m_subGraph.find(t), seen), seen);
                result = result.andThen(newTriples);
            }
            finished = true;
            Iterator iterator = result;
            return iterator;
        }
        finally {
            if (!finished) {
                result.close();
            }
        }
    }

    @Override
    public void addGraph(Graph graph) {
        if (!this.m_subGraphs.contains(graph)) {
            this.m_subGraphs.add(graph);
        }
    }

    public static class MultiUnionStatisticsHandler
    implements GraphStatisticsHandler {
        protected final MultiUnion mu;

        public MultiUnionStatisticsHandler(MultiUnion mu) {
            this.mu = mu;
        }

        @Override
        public long getStatistic(Node S, Node P, Node O) {
            long result = 0L;
            for (int i = 0; i < this.mu.m_subGraphs.size(); ++i) {
                Graph g2 = (Graph)this.mu.m_subGraphs.get(i);
                GraphStatisticsHandler s2 = g2.getStatisticsHandler();
                long n = s2.getStatistic(S, P, O);
                if (n < 0L) {
                    return n;
                }
                result += n;
            }
            return result;
        }

        public MultiUnion getUnion() {
            return this.mu;
        }
    }
}

