/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.geometry.isoonjts.spatialschema.geometry.primitive;

import java.util.List;
import org.geotoolkit.geometry.GeneralDirectPosition;
import org.geotoolkit.geometry.isoonjts.spatialschema.geometry.geometry.JTSGeometryFactory;
import org.geotoolkit.geometry.isoonjts.spatialschema.geometry.primitive.JTSCurve;
import org.geotoolkit.geometry.isoonjts.spatialschema.geometry.primitive.JTSPoint;
import org.geotoolkit.geometry.isoonjts.spatialschema.geometry.primitive.JTSPolyhedralSurface;
import org.geotoolkit.geometry.isoonjts.spatialschema.geometry.primitive.JTSRing;
import org.geotoolkit.geometry.isoonjts.spatialschema.geometry.primitive.JTSSurface;
import org.geotoolkit.geometry.isoonjts.spatialschema.geometry.primitive.JTSSurfaceBoundary;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.geometry.MismatchedReferenceSystemException;
import org.opengis.geometry.coordinate.GeometryFactory;
import org.opengis.geometry.coordinate.Polygon;
import org.opengis.geometry.coordinate.PolyhedralSurface;
import org.opengis.geometry.coordinate.Position;
import org.opengis.geometry.primitive.Curve;
import org.opengis.geometry.primitive.CurveSegment;
import org.opengis.geometry.primitive.Point;
import org.opengis.geometry.primitive.Primitive;
import org.opengis.geometry.primitive.PrimitiveFactory;
import org.opengis.geometry.primitive.Ring;
import org.opengis.geometry.primitive.Solid;
import org.opengis.geometry.primitive.SolidBoundary;
import org.opengis.geometry.primitive.Surface;
import org.opengis.geometry.primitive.SurfaceBoundary;
import org.opengis.geometry.primitive.SurfacePatch;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class JTSPrimitiveFactory
implements PrimitiveFactory {
    private final CoordinateReferenceSystem crs;
    private GeometryFactory geomFact;

    public JTSPrimitiveFactory() {
        this(null);
    }

    public JTSPrimitiveFactory(CoordinateReferenceSystem crs) {
        this.crs = crs;
        this.geomFact = new JTSGeometryFactory(crs);
    }

    @Override
    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.crs;
    }

    @Override
    public Primitive createPrimitive(Envelope envelope) {
        return null;
    }

    public DirectPosition createDirectPosition(double[] coordinates) {
        if (coordinates == null) {
            GeneralDirectPosition position = new GeneralDirectPosition(this.crs);
            return position;
        }
        GeneralDirectPosition position = new GeneralDirectPosition(coordinates);
        position.setCoordinateReferenceSystem(this.crs);
        return position;
    }

    @Override
    public Point createPoint(double[] coordinates) {
        return new JTSPoint(this.createDirectPosition(coordinates), this.crs);
    }

    @Override
    public Point createPoint(Position position) {
        return new JTSPoint(position.getDirectPosition(), this.crs);
    }

    @Override
    public Curve createCurve(List<CurveSegment> segments) {
        JTSCurve result = new JTSCurve(this.crs);
        if (segments != null) {
            result.getSegments().addAll(segments);
        }
        return result;
    }

    @Override
    public Surface createSurface(List<SurfacePatch> patches) {
        JTSSurface result = new JTSSurface(this.crs);
        List<SurfacePatch> cast = patches;
        result.getPatches().addAll(cast);
        return result;
    }

    @Override
    public Surface createSurface(SurfaceBoundary boundary) {
        JTSSurface result = new JTSSurface(this.crs);
        Polygon poly = this.geomFact.createPolygon(boundary);
        result.getPatches().add(poly);
        return result;
    }

    public SurfaceBoundary createSurfaceBoundary(Ring exterior, List interiors) throws MismatchedReferenceSystemException, MismatchedDimensionException {
        return new JTSSurfaceBoundary(this.crs, exterior, interiors.toArray(new Ring[interiors.size()]));
    }

    @Override
    public Solid createSolid(SolidBoundary boundary) {
        return null;
    }

    public Ring createRing(List curves) {
        JTSRing result = new JTSRing(this.crs);
        if (curves != null) {
            result.getGenerators().addAll(curves);
        }
        return result;
    }

    public PolyhedralSurface createPolyhedralSurface(List<Polygon> patches) throws MismatchedReferenceSystemException, MismatchedDimensionException {
        JTSPolyhedralSurface result = new JTSPolyhedralSurface(this.crs);
        List<Polygon> cast = patches;
        result.getPatches().addAll(cast);
        return result;
    }
}

