/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.gml.xml.v311;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import org.geotoolkit.gml.xml.v311.AbstractGeometryType;
import org.geotoolkit.gml.xml.v311.GridLimitsType;
import org.geotoolkit.gml.xml.v311.RectifiedGridType;
import org.opengis.coverage.grid.Grid;
import org.opengis.filter.expression.ExpressionVisitor;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="GridType", propOrder={"limits", "axisName"})
@XmlSeeAlso(value={RectifiedGridType.class})
public class GridType
extends AbstractGeometryType {
    @XmlElement(required=true)
    private GridLimitsType limits;
    @XmlElement(required=true)
    private List<String> axisName;
    @XmlAttribute(required=true)
    @XmlSchemaType(name="positiveInteger")
    private Integer dimension;

    GridType() {
    }

    public GridType(GridLimitsType limits, List<String> axisName) {
        this.axisName = axisName;
        if (axisName != null) {
            this.dimension = axisName.size();
        }
        this.limits = limits;
    }

    public GridType(Grid grid) {
        if (grid != null) {
            this.axisName = grid.getAxisNames();
            this.dimension = grid.getDimension();
            this.limits = new GridLimitsType(grid.getExtent());
        }
    }

    public GridLimitsType getLimits() {
        return this.limits;
    }

    public void setLimits(GridLimitsType limits) {
        this.limits = limits;
    }

    public List<String> getAxisName() {
        if (this.axisName == null) {
            this.axisName = new ArrayList<String>();
        }
        return this.axisName;
    }

    public void setAxisName(List<String> axisName) {
        this.axisName = axisName;
    }

    public Integer getDimension() {
        return this.dimension;
    }

    public void setDimension(Integer dimension) {
        this.dimension = dimension;
    }

    @Override
    public Object evaluate(Object object) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public <T> T evaluate(Object object, Class<T> context) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Object accept(ExpressionVisitor visitor, Object extraData) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

