/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.metadata.sql;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.geotoolkit.internal.sql.StatementEntry;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.logging.Logging;

final class MetadataResult
extends StatementEntry {
    private final Class<?> type;
    private ResultSet results;
    private String identifier;

    MetadataResult(Class<?> clazz, PreparedStatement preparedStatement) {
        super(preparedStatement);
        this.type = clazz;
    }

    private void closeResultSet() throws SQLException {
        boolean bl = this.results.next();
        this.results.close();
        this.results = null;
        if (bl) {
            LogRecord logRecord = Errors.getResources(null).getLogRecord(Level.WARNING, 55, this.identifier);
            logRecord.setSourceClassName(this.type.getCanonicalName());
            logRecord.setSourceMethodName("<init>");
            Logging.getLogger(MetadataResult.class).log(logRecord);
        }
        this.identifier = null;
    }

    private ResultSet getResultSet(String string) throws SQLException {
        if (this.results != null) {
            if (this.identifier.equals(string)) {
                return this.results;
            }
            this.closeResultSet();
        }
        this.statement.setString(1, string);
        this.results = this.statement.executeQuery();
        if (!this.results.next()) {
            String string2 = this.results.getMetaData().getTableName(1);
            this.results.close();
            this.results = null;
            throw new SQLException(Errors.format(192, string2, string));
        }
        this.identifier = string;
        return this.results;
    }

    public Object getObject(String string, String string2) throws SQLException {
        return this.getResultSet(string).getObject(string2);
    }

    @Override
    public void close() throws SQLException {
        if (this.results != null) {
            this.closeResultSet();
        }
        super.close();
    }
}

