/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation.projection;

import org.geotoolkit.lang.Static;
import org.geotoolkit.referencing.operation.projection.ProjectionError;
import org.geotoolkit.referencing.operation.projection.ProjectionException;
import org.geotoolkit.resources.Errors;
import org.opengis.referencing.operation.Matrix;

final class Assertions
extends Static {
    private static final double INVERSE_TOLERANCE = 1.0E-7;
    private static final double FORWARD_TOLERANCE = 1.0E-7;
    private static final double DERIVATIVE_TOLERANCE = 0.1;

    private Assertions() {
    }

    static boolean checkTransform(double[] dArray, int n, double d, double d2, double d3) throws ProjectionException {
        if (dArray != null) {
            Assertions.compare("x", dArray[n], d, d3);
            Assertions.compare("y", dArray[n + 1], d2, d3);
        }
        return d3 < Double.POSITIVE_INFINITY;
    }

    static boolean checkTransform(double[] dArray, int n, double d, double d2) throws ProjectionException {
        return Assertions.checkTransform(dArray, n, d, d2, 1.0E-7);
    }

    static boolean checkInverseTransform(double[] dArray, int n, double d, double d2, double d3) throws ProjectionException {
        Assertions.compare("latitude", dArray[n + 1], d2, d3);
        if (Math.abs(1.5707963267948966 - Math.abs(d2)) > 1.0E-6) {
            Assertions.compare("longitude", dArray[n], d, d3);
        }
        return d3 < Double.POSITIVE_INFINITY;
    }

    static boolean checkInverseTransform(double[] dArray, int n, double d, double d2) throws ProjectionException {
        return Assertions.checkInverseTransform(dArray, n, d, d2, 1.0E-7);
    }

    static boolean checkDerivative(Matrix matrix, Matrix matrix2) throws ProjectionException {
        if (matrix != null || matrix2 != null) {
            Assertions.compare("m00", matrix.getElement(0, 0), matrix2.getElement(0, 0), 0.1);
            Assertions.compare("m01", matrix.getElement(0, 1), matrix2.getElement(0, 1), 0.1);
            Assertions.compare("m10", matrix.getElement(1, 0), matrix2.getElement(1, 0), 0.1);
            Assertions.compare("m11", matrix.getElement(1, 1), matrix2.getElement(1, 1), 0.1);
        }
        return true;
    }

    private static void compare(String string, double d, double d2, double d3) throws ProjectionException {
        double d4 = Math.abs(d - d2);
        if (d4 > d3) {
            if (string.charAt(0) == 'l') {
                d2 = Math.toDegrees(d2);
                d = Math.toDegrees(d);
            } else if (Math.abs(d2) > 30.0 && Math.abs(d) > 30.0 && Math.signum(d2) == Math.signum(d)) {
                return;
            }
            throw new ProjectionError(Errors.format(197, string, String.valueOf(d), String.valueOf(d2)) + "(\u0394" + string + '=' + d4 + " \u03b5=" + d3 + ')');
        }
    }
}

