/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.temporal.object;

import java.util.Date;
import org.geotoolkit.temporal.object.DefaultInstant;
import org.geotoolkit.temporal.object.DefaultPosition;
import org.geotoolkit.temporal.object.DefaultTemporalGeometricPrimitive;
import org.geotoolkit.util.Utilities;
import org.opengis.temporal.Instant;
import org.opengis.temporal.Period;
import org.opengis.temporal.Position;
import org.opengis.temporal.RelativePosition;

public class DefaultPeriod
extends DefaultTemporalGeometricPrimitive
implements Period {
    private Instant begining;
    private Instant ending;

    public DefaultPeriod() {
    }

    public DefaultPeriod(Instant begining, Instant ending) {
        if (begining != null && (RelativePosition.BEFORE.equals(begining.relativePosition(ending)) || RelativePosition.EQUALS.equals(begining.relativePosition(ending)))) {
            this.begining = begining;
            this.ending = ending;
        }
    }

    @Override
    public Instant getBeginning() {
        return this.begining;
    }

    public void setBegining(Instant begining) {
        this.begining = begining;
    }

    public void setBegining(Date date) {
        this.begining = new DefaultInstant(new DefaultPosition(date));
    }

    public void setBegining(Position pos) {
        this.begining = new DefaultInstant(pos);
    }

    @Override
    public Instant getEnding() {
        return this.ending;
    }

    public void setEnding(Instant ending) {
        this.ending = ending;
    }

    public void setEnding(Position pos) {
        this.ending = new DefaultInstant(pos);
    }

    public void setEnding(Date date) {
        this.ending = new DefaultInstant(new DefaultPosition(date));
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof DefaultPeriod) {
            DefaultPeriod that = (DefaultPeriod)object;
            return Utilities.equals(this.begining, that.begining) && Utilities.equals(this.ending, that.ending);
        }
        return false;
    }

    public int hashCode() {
        int hash = 5;
        hash = 37 * hash + (this.begining != null ? this.begining.hashCode() : 0);
        hash = 37 * hash + (this.ending != null ? this.ending.hashCode() : 0);
        return hash;
    }

    public String toString() {
        StringBuilder s2 = new StringBuilder("Period:").append('\n');
        if (this.begining != null) {
            s2.append("begin:").append(this.begining).append('\n');
        }
        if (this.ending != null) {
            s2.append("end:").append(this.ending).append('\n');
        }
        return s2.toString();
    }
}

