/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.iso19142.basic.filter;

import com.sun.jersey.api.client.ClientResponse;
import java.util.HashMap;
import java.util.List;
import javax.xml.namespace.QName;
import org.opengis.cite.iso19142.ETSAssert;
import org.opengis.cite.iso19142.ErrorMessage;
import org.opengis.cite.iso19142.ProtocolBinding;
import org.opengis.cite.iso19142.basic.filter.QueryFilterFixture;
import org.opengis.cite.iso19142.util.WFSMessage;
import org.opengis.cite.iso19142.util.XMLUtils;
import org.testng.Assert;
import org.testng.SkipException;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PropertyIsNilOperatorTests
extends QueryFilterFixture {
    @Test(description="See ISO 19143: 7.7.3.6, A.6", dataProvider="protocol-featureType")
    public void propertyIsNil(ProtocolBinding binding, QName featureType) {
        List<QName> nillables = this.dataSampler.getNillableProperties(this.getModel(), featureType);
        if (nillables.isEmpty()) {
            throw new SkipException("FeatureType " + featureType + " does not contain at least one nillable property");
        }
        this.reqEntity = WFSMessage.createRequestEntity("GetFeature-Minimal", this.wfsVersion);
        WFSMessage.appendSimpleQuery(this.reqEntity, featureType);
        QName propName = nillables.get(nillables.size() - 1);
        this.addPropertyIsNilPredicate(this.reqEntity, propName, null, false);
        ClientResponse rsp = this.wfsClient.submitRequest(this.reqEntity, binding);
        this.rspEntity = this.extractBodyAsDocument(rsp);
        Assert.assertEquals(rsp.getStatus(), ClientResponse.Status.OK.getStatusCode(), ErrorMessage.get("UnexpectedStatus"));
        NodeList features = this.rspEntity.getElementsByTagNameNS("http://www.opengis.net/wfs/2.0", "member");
        String xpath = String.format("ns1:%s[@xsi:nil='true']", propName.getLocalPart());
        HashMap<String, String> nsBindings = new HashMap<String, String>();
        nsBindings.put(propName.getNamespaceURI(), "ns1");
        Node featureNode = null;
        for (int i = 0; i < features.getLength(); ++i) {
            featureNode = XMLUtils.getElementByNamespaceURIandLocalPart(features.item(i), featureType.getNamespaceURI(), featureType.getLocalPart());
            if (featureNode != null) {
                ETSAssert.assertXPath(xpath, featureNode, nsBindings);
                continue;
            }
            Assert.fail("No node found.");
        }
    }

    void addPropertyIsNilPredicate(Document request, QName propertyName, String nilReason, boolean negate) {
        if (!request.getDocumentElement().getLocalName().equals("GetFeature")) {
            throw new IllegalArgumentException("Not a GetFeature request: " + request.getDocumentElement().getNodeName());
        }
        if (null == propertyName) {
            throw new IllegalArgumentException("propertyName is required.");
        }
        Element queryElem = (Element)request.getElementsByTagNameNS("http://www.opengis.net/wfs/2.0", "Query").item(0);
        Element filter = request.createElementNS("http://www.opengis.net/fes/2.0", "Filter");
        queryElem.appendChild(filter);
        Element predicate = request.createElementNS("http://www.opengis.net/fes/2.0", "PropertyIsNil");
        if (null != nilReason && !nilReason.isEmpty()) {
            predicate.setAttribute("nilReason", nilReason);
        }
        if (negate) {
            Element not = request.createElementNS("http://www.opengis.net/fes/2.0", "Not");
            filter.appendChild(not);
            not.appendChild(predicate);
        } else {
            filter.appendChild(predicate);
        }
        Element valueRef = request.createElementNS("http://www.opengis.net/fes/2.0", "ValueReference");
        predicate.appendChild(valueRef);
        String prefix = propertyName.getPrefix().length() > 0 ? propertyName.getPrefix() : "tns";
        String nsURI = request.lookupNamespaceURI(prefix);
        if (null == nsURI) {
            valueRef.setAttribute("xmlns:" + prefix, propertyName.getNamespaceURI());
        }
        valueRef.setTextContent(prefix + ":" + propertyName.getLocalPart());
    }
}

