/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.iso19142.simple;

import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;
import org.opengis.cite.iso19142.BaseFixture;
import org.opengis.cite.iso19142.ETSAssert;
import org.opengis.cite.iso19142.ErrorMessage;
import org.opengis.cite.iso19142.SuiteAttribute;
import org.opengis.cite.iso19142.util.ValidationUtils;
import org.opengis.cite.iso19142.util.XMLUtils;
import org.opengis.cite.validation.SchematronValidator;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class ServiceMetadataTests
extends BaseFixture {
    static final String ROOT_PKG = "/org/opengis/cite/iso19142/";
    static final String SIMPLE_WFS_PHASE = "SimpleWFSPhase";
    private Schema wfsSchema;

    @BeforeClass(alwaysRun=true)
    public void obtainWFSSchema(ITestContext testContext) {
        this.wfsSchema = (Schema)testContext.getSuite().getAttribute(SuiteAttribute.WFS_SCHEMA.getName());
        Assert.assertNotNull(this.wfsSchema, "WFS schema not found in suite fixture.");
    }

    @Test(description="See ISO 19142: 8.3.2")
    public void capabilitiesDocIsXmlSchemaValid() {
        Validator validator = this.wfsSchema.newValidator();
        ETSAssert.assertSchemaValid(validator, new DOMSource(this.wfsMetadata, this.wfsMetadata.getDocumentURI()));
    }

    @Test(description="See ISO 19142: A.1.1, A.2.23")
    public void capabilitiesDocCorrespondsToWfsSimple() {
        SchematronValidator validator = ValidationUtils.buildSchematronValidator("wfs-capabilities-2.0.sch", SIMPLE_WFS_PHASE);
        Result result = validator.validate(new DOMSource(this.wfsMetadata, this.wfsMetadata.getDocumentURI()), false);
        Assert.assertFalse(validator.ruleViolationsDetected(), ErrorMessage.format("NotSchemaValid", validator.getRuleViolationCount(), XMLUtils.resultToString(result)));
    }
}

