/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.iso19142.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;

public class NamespaceBindings
implements NamespaceContext {
    private Map<String, String> bindings = new HashMap<String, String>();

    @Override
    public String getNamespaceURI(String prefix) {
        String nsName = null;
        for (Map.Entry<String, String> binding : this.bindings.entrySet()) {
            if (!binding.getValue().equals(prefix)) continue;
            nsName = binding.getKey();
            break;
        }
        return nsName;
    }

    @Override
    public String getPrefix(String namespaceURI) {
        return this.bindings.get(namespaceURI);
    }

    @Override
    public Iterator<String> getPrefixes(String namespaceURI) {
        return Arrays.asList(this.getPrefix(namespaceURI)).iterator();
    }

    public void addNamespaceBinding(String namespaceURI, String prefix) {
        this.bindings.put(namespaceURI, prefix);
    }

    public void addAllBindings(Map<String, String> nsBindings) {
        if (null != nsBindings) {
            this.bindings.putAll(nsBindings);
        }
    }

    public Map<String, String> getAllBindings() {
        return Collections.unmodifiableMap(this.bindings);
    }

    public static NamespaceBindings withStandardBindings() {
        NamespaceBindings nsBindings = new NamespaceBindings();
        nsBindings.addNamespaceBinding("http://www.opengis.net/wfs/2.0", "wfs");
        nsBindings.addNamespaceBinding("http://www.opengis.net/fes/2.0", "fes");
        nsBindings.addNamespaceBinding("http://www.opengis.net/ows/1.1", "ows");
        nsBindings.addNamespaceBinding("http://www.w3.org/1999/xlink", "xlink");
        nsBindings.addNamespaceBinding("http://www.opengis.net/gml/3.2", "gml");
        nsBindings.addNamespaceBinding("http://www.w3.org/2003/05/soap-envelope", "soap");
        nsBindings.addNamespaceBinding("http://schemas.xmlsoap.org/soap/envelope/", "soap11");
        nsBindings.addNamespaceBinding("http://www.w3.org/2001/XMLSchema-instance", "xsi");
        return nsBindings;
    }

    public String toString() {
        return "NamespaceBindings:\n" + this.bindings;
    }
}

