/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.internal;

import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.geotoolkit.util.logging.Logging;

public final class Threads
extends AtomicInteger
implements ThreadFactory,
RejectedExecutionHandler {
    public static final ThreadGroup GEOTOOLKIT;
    public static final ThreadGroup RESOURCE_DISPOSERS;
    public static final ThreadGroup WORKERS;
    private static final ExecutorService WORK_EXECUTOR;
    private static final ScheduledExecutorService DISPOSAL_EXECUTOR;
    private final boolean disposer;
    private final boolean daemon;
    private final String prefix;

    private Threads(boolean bl, boolean bl2, String string) {
        this.disposer = bl;
        this.daemon = bl2;
        this.prefix = string;
    }

    public static ThreadFactory createThreadFactory(String string) {
        return new Threads(false, false, string);
    }

    public static void executeWork(Runnable runnable) {
        WORK_EXECUTOR.execute(runnable);
    }

    public static void executeDisposal(Runnable runnable, long l) {
        DISPOSAL_EXECUTOR.schedule(runnable, l, TimeUnit.MILLISECONDS);
    }

    @Override
    public Thread newThread(Runnable runnable) {
        String string = this.prefix + this.incrementAndGet();
        Thread thread = new Thread(this.disposer ? RESOURCE_DISPOSERS : WORKERS, runnable, string);
        thread.setPriority(6);
        thread.setDaemon(this.daemon);
        return thread;
    }

    @Override
    public void rejectedExecution(Runnable runnable, ThreadPoolExecutor threadPoolExecutor) {
        try {
            threadPoolExecutor.getQueue().put(runnable);
        }
        catch (InterruptedException interruptedException) {
            throw new RejectedExecutionException(interruptedException);
        }
    }

    public static synchronized void shutdown() {
        WORK_EXECUTOR.shutdown();
        DISPOSAL_EXECUTOR.shutdown();
        ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor)((Object)DISPOSAL_EXECUTOR);
        for (Runnable runnable : threadPoolExecutor.getQueue()) {
            if (!threadPoolExecutor.remove(runnable)) continue;
            try {
                runnable.run();
            }
            catch (Exception exception) {
                System.err.println(exception);
            }
        }
        try {
            if (!(WORK_EXECUTOR.awaitTermination(8L, TimeUnit.SECONDS) && DISPOSAL_EXECUTOR.awaitTermination(2L, TimeUnit.SECONDS) || WORK_EXECUTOR.isTerminated() && DISPOSAL_EXECUTOR.isTerminated())) {
                System.err.println("NOTE: Some background threads didn't completed.");
            }
        }
        catch (InterruptedException interruptedException) {
            System.err.println(interruptedException);
        }
    }

    public static Thread[] getNonDaemonThreads() {
        Thread[] threadArray;
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        while ((threadArray = threadGroup.getParent()) != null) {
            threadGroup = threadArray;
        }
        int n = threadGroup.activeCount();
        while ((n = threadGroup.enumerate(threadArray = new Thread[n << 1])) == threadArray.length) {
        }
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            Thread thread = threadArray[i];
            if (thread.isDaemon()) continue;
            threadArray[n2++] = thread;
        }
        return Arrays.copyOf(threadArray, n2);
    }

    static {
        Object object = Thread.currentThread().getThreadGroup();
        try {
            ThreadGroup threadGroup;
            while ((threadGroup = ((ThreadGroup)object).getParent()) != null) {
                object = threadGroup;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        GEOTOOLKIT = new ThreadGroup((ThreadGroup)object, "Geotoolkit.org");
        RESOURCE_DISPOSERS = new ThreadGroup(GEOTOOLKIT, "ResourceDisposers");
        RESOURCE_DISPOSERS.setMaxPriority(7);
        WORKERS = new ThreadGroup(GEOTOOLKIT, "Workers");
        object = new Threads(false, true, "Pooled thread #");
        int n = Math.max(2, Runtime.getRuntime().availableProcessors());
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(2, n, 5L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(1000), (ThreadFactory)object, (RejectedExecutionHandler)object);
        threadPoolExecutor.allowCoreThreadTimeOut(true);
        WORK_EXECUTOR = threadPoolExecutor;
        DISPOSAL_EXECUTOR = Executors.newScheduledThreadPool(1, new Threads(true, true, "Disposer thread #"));
        try {
            Class.forName("org.geotoolkit.factory.ShutdownHook", true, Threads.class.getClassLoader());
        }
        catch (Exception exception) {
            Logging.unexpectedException(Threads.class, "<init>", exception);
        }
    }
}

