/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.distance3d;

import com.vividsolutions.jts.algorithm.CGAlgorithms3D;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineSegment;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.operation.distance.GeometryLocation;
import com.vividsolutions.jts.operation.distance3d.PlanarPolygon3D;

public class Distance3DOp {
    private Geometry[] geom;
    private double terminateDistance = 0.0;
    private GeometryLocation[] minDistanceLocation;
    private double minDistance = Double.MAX_VALUE;
    private boolean isDone = false;

    public static double distance(Geometry g0, Geometry g1) {
        Distance3DOp distOp = new Distance3DOp(g0, g1);
        return distOp.distance();
    }

    public static boolean isWithinDistance(Geometry g0, Geometry g1, double distance) {
        Distance3DOp distOp = new Distance3DOp(g0, g1, distance);
        return distOp.distance() <= distance;
    }

    public static Coordinate[] nearestPoints(Geometry g0, Geometry g1) {
        Distance3DOp distOp = new Distance3DOp(g0, g1);
        return distOp.nearestPoints();
    }

    public Distance3DOp(Geometry g0, Geometry g1) {
        this(g0, g1, 0.0);
    }

    public Distance3DOp(Geometry g0, Geometry g1, double terminateDistance) {
        this.geom = new Geometry[2];
        this.geom[0] = g0;
        this.geom[1] = g1;
        this.terminateDistance = terminateDistance;
    }

    public double distance() {
        if (this.geom[0] == null || this.geom[1] == null) {
            throw new IllegalArgumentException("null geometries are not supported");
        }
        if (this.geom[0].isEmpty() || this.geom[1].isEmpty()) {
            return 0.0;
        }
        this.computeMinDistance();
        return this.minDistance;
    }

    public Coordinate[] nearestPoints() {
        this.computeMinDistance();
        Coordinate[] nearestPts = new Coordinate[]{this.minDistanceLocation[0].getCoordinate(), this.minDistanceLocation[1].getCoordinate()};
        return nearestPts;
    }

    public GeometryLocation[] nearestLocations() {
        this.computeMinDistance();
        return this.minDistanceLocation;
    }

    private void updateDistance(double dist, GeometryLocation loc0, GeometryLocation loc1, boolean flip) {
        this.minDistance = dist;
        int index = flip ? 1 : 0;
        this.minDistanceLocation[index] = loc0;
        this.minDistanceLocation[1 - index] = loc1;
        if (this.minDistance < this.terminateDistance) {
            this.isDone = true;
        }
    }

    private void computeMinDistance() {
        if (this.minDistanceLocation != null) {
            return;
        }
        this.minDistanceLocation = new GeometryLocation[2];
        int geomIndex = this.mostPolygonalIndex();
        boolean flip = geomIndex == 0;
        this.computeMinDistanceMultiMulti(this.geom[geomIndex], this.geom[1 - geomIndex], flip);
    }

    private int mostPolygonalIndex() {
        int dim0 = this.geom[0].getDimension();
        int dim1 = this.geom[1].getDimension();
        if (dim0 >= 2 && dim1 >= 2) {
            if (this.geom[0].getNumPoints() > this.geom[1].getNumPoints()) {
                return 0;
            }
            return 1;
        }
        if (dim0 >= 2) {
            return 0;
        }
        if (dim1 >= 2) {
            return 1;
        }
        return 0;
    }

    private void computeMinDistanceMultiMulti(Geometry g0, Geometry g1, boolean flip) {
        if (g0 instanceof GeometryCollection) {
            int n = g0.getNumGeometries();
            for (int i = 0; i < n; ++i) {
                Geometry g2 = g0.getGeometryN(i);
                this.computeMinDistanceMultiMulti(g2, g1, flip);
                if (!this.isDone) continue;
                return;
            }
        } else {
            if (g0.isEmpty()) {
                return;
            }
            if (g0 instanceof Polygon) {
                this.computeMinDistanceOneMulti(Distance3DOp.polyPlane(g0), g1, flip);
            } else {
                this.computeMinDistanceOneMulti(g0, g1, flip);
            }
        }
    }

    private void computeMinDistanceOneMulti(Geometry g0, Geometry g1, boolean flip) {
        if (g1 instanceof GeometryCollection) {
            int n = g1.getNumGeometries();
            for (int i = 0; i < n; ++i) {
                Geometry g2 = g1.getGeometryN(i);
                this.computeMinDistanceOneMulti(g0, g2, flip);
                if (!this.isDone) continue;
                return;
            }
        } else {
            this.computeMinDistance(g0, g1, flip);
        }
    }

    private void computeMinDistanceOneMulti(PlanarPolygon3D poly, Geometry geom, boolean flip) {
        if (geom instanceof GeometryCollection) {
            int n = geom.getNumGeometries();
            for (int i = 0; i < n; ++i) {
                Geometry g2 = geom.getGeometryN(i);
                this.computeMinDistanceOneMulti(poly, g2, flip);
                if (!this.isDone) continue;
                return;
            }
        } else {
            if (geom instanceof Point) {
                this.computeMinDistancePolygonPoint(poly, (Point)geom, flip);
                return;
            }
            if (geom instanceof LineString) {
                this.computeMinDistancePolygonLine(poly, (LineString)geom, flip);
                return;
            }
            if (geom instanceof Polygon) {
                this.computeMinDistancePolygonPolygon(poly, (Polygon)geom, flip);
                return;
            }
        }
    }

    private static PlanarPolygon3D polyPlane(Geometry poly) {
        return new PlanarPolygon3D((Polygon)poly);
    }

    private void computeMinDistance(Geometry g0, Geometry g1, boolean flip) {
        if (g0 instanceof Point) {
            if (g1 instanceof Point) {
                this.computeMinDistancePointPoint((Point)g0, (Point)g1, flip);
                return;
            }
            if (g1 instanceof LineString) {
                this.computeMinDistanceLinePoint((LineString)g1, (Point)g0, !flip);
                return;
            }
            if (g1 instanceof Polygon) {
                this.computeMinDistancePolygonPoint(Distance3DOp.polyPlane(g1), (Point)g0, !flip);
                return;
            }
        }
        if (g0 instanceof LineString) {
            if (g1 instanceof Point) {
                this.computeMinDistanceLinePoint((LineString)g0, (Point)g1, flip);
                return;
            }
            if (g1 instanceof LineString) {
                this.computeMinDistanceLineLine((LineString)g0, (LineString)g1, flip);
                return;
            }
            if (g1 instanceof Polygon) {
                this.computeMinDistancePolygonLine(Distance3DOp.polyPlane(g1), (LineString)g0, !flip);
                return;
            }
        }
        if (g0 instanceof Polygon) {
            if (g1 instanceof Point) {
                this.computeMinDistancePolygonPoint(Distance3DOp.polyPlane(g0), (Point)g1, flip);
                return;
            }
            if (g1 instanceof LineString) {
                this.computeMinDistancePolygonLine(Distance3DOp.polyPlane(g0), (LineString)g1, flip);
                return;
            }
            if (g1 instanceof Polygon) {
                this.computeMinDistancePolygonPolygon(Distance3DOp.polyPlane(g0), (Polygon)g1, flip);
                return;
            }
        }
    }

    private void computeMinDistancePolygonPolygon(PlanarPolygon3D poly0, Polygon poly1, boolean flip) {
        this.computeMinDistancePolygonRings(poly0, poly1, flip);
        if (this.isDone) {
            return;
        }
        PlanarPolygon3D polyPlane1 = new PlanarPolygon3D(poly1);
        this.computeMinDistancePolygonRings(polyPlane1, poly0.getPolygon(), flip);
    }

    private void computeMinDistancePolygonRings(PlanarPolygon3D poly, Polygon ringPoly, boolean flip) {
        this.computeMinDistancePolygonLine(poly, ringPoly.getExteriorRing(), flip);
        if (this.isDone) {
            return;
        }
        int nHole = ringPoly.getNumInteriorRing();
        for (int i = 0; i < nHole; ++i) {
            this.computeMinDistancePolygonLine(poly, ringPoly.getInteriorRingN(i), flip);
            if (!this.isDone) continue;
            return;
        }
    }

    private void computeMinDistancePolygonLine(PlanarPolygon3D poly, LineString line, boolean flip) {
        Coordinate intPt = this.intersection(poly, line);
        if (intPt != null) {
            this.updateDistance(0.0, new GeometryLocation(poly.getPolygon(), 0, intPt), new GeometryLocation(line, 0, intPt), flip);
            return;
        }
        this.computeMinDistanceLineLine(poly.getPolygon().getExteriorRing(), line, flip);
        if (this.isDone) {
            return;
        }
        int nHole = poly.getPolygon().getNumInteriorRing();
        for (int i = 0; i < nHole; ++i) {
            this.computeMinDistanceLineLine(poly.getPolygon().getInteriorRingN(i), line, flip);
            if (!this.isDone) continue;
            return;
        }
    }

    private Coordinate intersection(PlanarPolygon3D poly, LineString line) {
        CoordinateSequence seq = line.getCoordinateSequence();
        if (seq.size() == 0) {
            return null;
        }
        Coordinate p0 = new Coordinate();
        seq.getCoordinate(0, p0);
        double d0 = poly.getPlane().orientedDistance(p0);
        Coordinate p1 = new Coordinate();
        for (int i = 0; i < seq.size() - 1; ++i) {
            seq.getCoordinate(i, p0);
            seq.getCoordinate(i + 1, p1);
            double d1 = poly.getPlane().orientedDistance(p1);
            if (d0 * d1 > 0.0) continue;
            Coordinate intPt = Distance3DOp.segmentPoint(p0, p1, d0, d1);
            if (poly.intersects(intPt)) {
                return intPt;
            }
            d0 = d1;
        }
        return null;
    }

    private void computeMinDistancePolygonPoint(PlanarPolygon3D polyPlane, Point point, boolean flip) {
        LineString shell;
        Coordinate pt = point.getCoordinate();
        if (polyPlane.intersects(pt, shell = polyPlane.getPolygon().getExteriorRing())) {
            int nHole = polyPlane.getPolygon().getNumInteriorRing();
            for (int i = 0; i < nHole; ++i) {
                LineString hole = polyPlane.getPolygon().getInteriorRingN(i);
                if (!polyPlane.intersects(pt, hole)) continue;
                this.computeMinDistanceLinePoint(hole, point, flip);
                return;
            }
            double dist = Math.abs(polyPlane.getPlane().orientedDistance(pt));
            this.updateDistance(dist, new GeometryLocation(polyPlane.getPolygon(), 0, pt), new GeometryLocation(point, 0, pt), flip);
        }
        this.computeMinDistanceLinePoint(shell, point, flip);
    }

    private void computeMinDistanceLineLine(LineString line0, LineString line1, boolean flip) {
        Coordinate[] coord0 = line0.getCoordinates();
        Coordinate[] coord1 = line1.getCoordinates();
        for (int i = 0; i < coord0.length - 1; ++i) {
            for (int j = 0; j < coord1.length - 1; ++j) {
                double dist = CGAlgorithms3D.distanceSegmentSegment(coord0[i], coord0[i + 1], coord1[j], coord1[j + 1]);
                if (dist < this.minDistance) {
                    this.minDistance = dist;
                    LineSegment seg0 = new LineSegment(coord0[i], coord0[i + 1]);
                    LineSegment seg1 = new LineSegment(coord1[j], coord1[j + 1]);
                    Coordinate[] closestPt = seg0.closestPoints(seg1);
                    this.updateDistance(dist, new GeometryLocation(line0, i, closestPt[0]), new GeometryLocation(line1, j, closestPt[1]), flip);
                }
                if (!this.isDone) continue;
                return;
            }
        }
    }

    private void computeMinDistanceLinePoint(LineString line, Point point, boolean flip) {
        Coordinate[] lineCoord = line.getCoordinates();
        Coordinate coord = point.getCoordinate();
        for (int i = 0; i < lineCoord.length - 1; ++i) {
            double dist = CGAlgorithms3D.distancePointSegment(coord, lineCoord[i], lineCoord[i + 1]);
            if (dist < this.minDistance) {
                LineSegment seg = new LineSegment(lineCoord[i], lineCoord[i + 1]);
                Coordinate segClosestPoint = seg.closestPoint(coord);
                this.updateDistance(dist, new GeometryLocation(line, i, segClosestPoint), new GeometryLocation(point, 0, coord), flip);
            }
            if (!this.isDone) continue;
            return;
        }
    }

    private void computeMinDistancePointPoint(Point point0, Point point1, boolean flip) {
        double dist = CGAlgorithms3D.distance(point0.getCoordinate(), point1.getCoordinate());
        if (dist < this.minDistance) {
            this.updateDistance(dist, new GeometryLocation(point0, 0, point0.getCoordinate()), new GeometryLocation(point1, 0, point1.getCoordinate()), flip);
        }
    }

    private static Coordinate segmentPoint(Coordinate p0, Coordinate p1, double d0, double d1) {
        if (d0 <= 0.0) {
            return new Coordinate(p0);
        }
        if (d1 <= 0.0) {
            return new Coordinate(p1);
        }
        double f = Math.abs(d0) / (Math.abs(d0) + Math.abs(d1));
        double intx = p0.x + f * (p1.x - p0.x);
        double inty = p0.y + f * (p1.y - p0.y);
        double intz = p0.z + f * (p1.z - p0.z);
        return new Coordinate(intx, inty, intz);
    }
}

