/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.StringTokenizer;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.sort.StringCollator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.DurationValue;
import net.sf.saxon.value.Whitespace;

public final class DayTimeDurationValue
extends DurationValue
implements Comparable {
    private DayTimeDurationValue() {
        this.typeLabel = BuiltInAtomicType.DAY_TIME_DURATION;
    }

    public static ConversionResult makeDayTimeDurationValue(CharSequence s2) {
        int days = 0;
        int hours = 0;
        int minutes = 0;
        int seconds = 0;
        int microseconds = 0;
        boolean negative = false;
        int components = 0;
        StringTokenizer tok = new StringTokenizer(Whitespace.trimWhitespace(s2).toString(), "-+.PDTHMS", true);
        if (!tok.hasMoreElements()) {
            return DayTimeDurationValue.badDuration("empty string", s2);
        }
        String part = (String)tok.nextElement();
        if ("+".equals(part)) {
            return DayTimeDurationValue.badDuration("+ sign not allowed in a duration", s2);
        }
        if ("-".equals(part)) {
            negative = true;
            part = (String)tok.nextElement();
        }
        if (!"P".equals(part)) {
            return DayTimeDurationValue.badDuration("missing 'P'", s2);
        }
        int state = 0;
        block9: while (tok.hasMoreElements()) {
            int value;
            part = (String)tok.nextElement();
            if ("T".equals(part)) {
                state = 4;
                if (!tok.hasMoreElements()) {
                    return DayTimeDurationValue.badDuration("T must be followed by time components", s2);
                }
                part = (String)tok.nextElement();
            }
            if ((value = DayTimeDurationValue.simpleInteger(part)) < 0) {
                return DayTimeDurationValue.badDuration("non-numeric component", s2);
            }
            if (!tok.hasMoreElements()) {
                return DayTimeDurationValue.badDuration("missing unit letter at end", s2);
            }
            char delim = ((String)tok.nextElement()).charAt(0);
            switch (delim) {
                case 'D': {
                    if (state > 2) {
                        return DayTimeDurationValue.badDuration("D is out of sequence", s2);
                    }
                    days = value;
                    ++components;
                    state = 3;
                    continue block9;
                }
                case 'H': {
                    if (state != 4) {
                        return DayTimeDurationValue.badDuration("H is out of sequence", s2);
                    }
                    hours = value;
                    ++components;
                    state = 5;
                    continue block9;
                }
                case 'M': {
                    if (state < 4 || state > 5) {
                        return DayTimeDurationValue.badDuration("M is out of sequence", s2);
                    }
                    minutes = value;
                    ++components;
                    state = 6;
                    continue block9;
                }
                case '.': {
                    if (state < 4 || state > 6) {
                        return DayTimeDurationValue.badDuration("misplaced decimal point", s2);
                    }
                    seconds = value;
                    ++components;
                    state = 7;
                    continue block9;
                }
                case 'S': {
                    if (state < 4 || state > 7) {
                        return DayTimeDurationValue.badDuration("S is out of sequence", s2);
                    }
                    if (state == 7) {
                        while (part.length() < 6) {
                            part = part + "0";
                        }
                        if (part.length() > 6) {
                            part = part.substring(0, 6);
                        }
                        if ((value = DayTimeDurationValue.simpleInteger(part)) < 0) {
                            return DayTimeDurationValue.badDuration("non-numeric microseconds component", s2);
                        }
                        microseconds = value;
                    } else {
                        seconds = value;
                    }
                    ++components;
                    state = 8;
                    continue block9;
                }
            }
            return DayTimeDurationValue.badDuration("misplaced " + delim, s2);
        }
        if (components == 0) {
            return DayTimeDurationValue.badDuration("Duration specifies no components", s2);
        }
        try {
            return new DayTimeDurationValue(negative ? -1 : 1, days, hours, minutes, seconds, microseconds);
        }
        catch (IllegalArgumentException err) {
            return new ValidationFailure(err.getMessage());
        }
    }

    public DayTimeDurationValue(int sign, int days, int hours, int minutes, long seconds, int microseconds) throws IllegalArgumentException {
        if (days < 0 || hours < 0 || minutes < 0 || seconds < 0L || microseconds < 0) {
            throw new IllegalArgumentException("Negative component value");
        }
        if ((double)days * 86400.0 + (double)hours * 3600.0 + (double)minutes * 60.0 + (double)seconds > 9.223372036854776E18) {
            throw new IllegalArgumentException("Duration seconds limit exceeded");
        }
        this.negative = sign < 0;
        this.months = 0;
        long h2 = (long)days * 24L + (long)hours;
        long m3 = h2 * 60L + (long)minutes;
        long s2 = m3 * 60L + seconds;
        if (microseconds > 1000000) {
            s2 += (long)(microseconds / 1000000);
            microseconds %= 1000000;
        }
        this.seconds = s2;
        this.microseconds = microseconds;
        if (s2 == 0L && microseconds == 0) {
            this.negative = false;
        }
        this.typeLabel = BuiltInAtomicType.DAY_TIME_DURATION;
    }

    public AtomicValue copyAsSubType(AtomicType typeLabel) {
        DayTimeDurationValue v = DayTimeDurationValue.fromMicroseconds(this.getLengthInMicroseconds());
        v.typeLabel = typeLabel;
        return v;
    }

    public BuiltInAtomicType getPrimitiveType() {
        return BuiltInAtomicType.DAY_TIME_DURATION;
    }

    public CharSequence getStringValueCS() {
        FastStringBuffer sb = new FastStringBuffer(32);
        if (this.negative) {
            sb.append('-');
        }
        int days = this.getDays();
        int hours = this.getHours();
        int minutes = this.getMinutes();
        int seconds = this.getSeconds();
        sb.append('P');
        if (days != 0) {
            sb.append(days + "D");
        }
        if (days == 0 || hours != 0 || minutes != 0 || seconds != 0 || this.microseconds != 0) {
            sb.append('T');
        }
        if (hours != 0) {
            sb.append(hours + "H");
        }
        if (minutes != 0) {
            sb.append(minutes + "M");
        }
        if (seconds != 0 || this.microseconds != 0 || days == 0 && minutes == 0 && hours == 0) {
            if (this.microseconds == 0) {
                sb.append(seconds + "S");
            } else {
                long ms = seconds * 1000000 + this.microseconds;
                String mss = ms + "";
                if (seconds == 0) {
                    mss = "0000000" + mss;
                    mss = mss.substring(mss.length() - 7);
                }
                sb.append(mss.substring(0, mss.length() - 6));
                sb.append('.');
                int lastSigDigit = mss.length() - 1;
                while (mss.charAt(lastSigDigit) == '0') {
                    --lastSigDigit;
                }
                sb.append(mss.substring(mss.length() - 6, lastSigDigit + 1));
                sb.append('S');
            }
        }
        return sb;
    }

    public double getLengthInSeconds() {
        double a = (double)this.seconds + (double)this.microseconds / 1000000.0;
        return this.negative ? -a : a;
    }

    public long getLengthInMilliseconds() {
        long a = this.seconds * 1000L + (long)(this.microseconds / 1000);
        return this.negative ? -a : a;
    }

    public long getLengthInMicroseconds() {
        long a = this.seconds * 1000000L + (long)this.microseconds;
        return this.negative ? -a : a;
    }

    public static DayTimeDurationValue fromSeconds(BigDecimal seconds) throws XPathException {
        DayTimeDurationValue sdv = new DayTimeDurationValue();
        boolean bl = sdv.negative = seconds.signum() < 0;
        if (sdv.negative) {
            seconds = seconds.negate();
        }
        BigDecimal microseconds = seconds.multiply(DecimalValue.BIG_DECIMAL_ONE_MILLION);
        BigInteger intMicros = microseconds.toBigInteger();
        BigInteger[] parts = intMicros.divideAndRemainder(BigInteger.valueOf(1000000L));
        sdv.seconds = parts[0].longValue();
        sdv.microseconds = parts[1].intValue();
        return sdv;
    }

    public static DayTimeDurationValue fromMilliseconds(long milliseconds) throws ValidationException {
        int sign = DayTimeDurationValue.longSignum(milliseconds);
        if (sign < 0) {
            milliseconds = -milliseconds;
        }
        try {
            return new DayTimeDurationValue(sign, 0, 0, 0, milliseconds / 1000L, (int)(milliseconds % 1000L) * 1000);
        }
        catch (IllegalArgumentException err) {
            throw new ValidationException("Duration exceeds limits");
        }
    }

    private static int longSignum(long value) {
        if (value > 0L) {
            return 1;
        }
        if (value == 0L) {
            return 0;
        }
        return -1;
    }

    public static DayTimeDurationValue fromMicroseconds(long microseconds) throws IllegalArgumentException {
        int sign = DayTimeDurationValue.longSignum(microseconds);
        if (sign < 0) {
            microseconds = -microseconds;
        }
        return new DayTimeDurationValue(sign, 0, 0, 0, microseconds / 1000000L, (int)(microseconds % 1000000L));
    }

    public DurationValue multiply(double n) throws XPathException {
        if (Double.isNaN(n)) {
            XPathException err = new XPathException("Cannot multiply/divide a duration by NaN");
            err.setErrorCode("FOCA0005");
            throw err;
        }
        double m3 = this.getLengthInMicroseconds();
        double product = n * m3;
        if (Double.isInfinite(product) || Double.isNaN(product) || product > 9.223372036854776E18 || product < -9.223372036854776E18) {
            XPathException err = new XPathException("Overflow when multiplying/dividing a duration by a number");
            err.setErrorCode("FODT0002");
            throw err;
        }
        try {
            return DayTimeDurationValue.fromMicroseconds((long)product);
        }
        catch (IllegalArgumentException err) {
            if (err.getCause() instanceof XPathException) {
                throw (XPathException)err.getCause();
            }
            XPathException err2 = new XPathException("Overflow when multiplying/dividing a duration by a number", err);
            err2.setErrorCode("FODT0002");
            throw err2;
        }
    }

    public DecimalValue divide(DurationValue other) throws XPathException {
        if (other instanceof DayTimeDurationValue) {
            BigDecimal v1 = BigDecimal.valueOf(this.getLengthInMicroseconds());
            BigDecimal v2 = BigDecimal.valueOf(((DayTimeDurationValue)other).getLengthInMicroseconds());
            if (v2.signum() == 0) {
                XPathException err = new XPathException("Divide by zero (durations)");
                err.setErrorCode("FOAR0001");
                throw err;
            }
            return new DecimalValue(v1.divide(v2, 20, 6));
        }
        XPathException err = new XPathException("Cannot divide two durations of different type");
        err.setErrorCode("XPTY0004");
        throw err;
    }

    public DurationValue add(DurationValue other) throws XPathException {
        if (other instanceof DayTimeDurationValue) {
            try {
                return DayTimeDurationValue.fromMicroseconds(this.getLengthInMicroseconds() + ((DayTimeDurationValue)other).getLengthInMicroseconds());
            }
            catch (IllegalArgumentException e) {
                XPathException err = new XPathException("Overflow when adding two durations");
                err.setErrorCode("FODT0002");
                throw err;
            }
        }
        XPathException err = new XPathException("Cannot add two durations of different type");
        err.setErrorCode("XPTY0004");
        throw err;
    }

    public DurationValue subtract(DurationValue other) throws XPathException {
        if (other instanceof DayTimeDurationValue) {
            try {
                return DayTimeDurationValue.fromMicroseconds(this.getLengthInMicroseconds() - ((DayTimeDurationValue)other).getLengthInMicroseconds());
            }
            catch (IllegalArgumentException e) {
                XPathException err = new XPathException("Overflow when subtracting two durations");
                err.setErrorCode("FODT0002");
                throw err;
            }
        }
        XPathException err = new XPathException("Cannot subtract two durations of different type");
        err.setErrorCode("XPTY0004");
        throw err;
    }

    public DurationValue negate() throws IllegalArgumentException {
        return DayTimeDurationValue.fromMicroseconds(-this.getLengthInMicroseconds());
    }

    public int compareTo(Object other) {
        if (other instanceof DayTimeDurationValue) {
            long diff = this.getLengthInMicroseconds() - ((DayTimeDurationValue)other).getLengthInMicroseconds();
            if (diff < 0L) {
                return -1;
            }
            if (diff > 0L) {
                return 1;
            }
            return 0;
        }
        throw new ClassCastException("Cannot compare a dayTimeDuration to an object of class " + other.getClass());
    }

    public Object getXPathComparable(boolean ordered, StringCollator collator, XPathContext context) {
        return this;
    }

    public Object convertToJava(Class target, XPathContext context) throws XPathException {
        if (target.isAssignableFrom(DurationValue.class)) {
            return this;
        }
        if (target == String.class || target == CharSequence.class) {
            return this.getStringValue();
        }
        if (target == Object.class) {
            return this.getStringValue();
        }
        XPathException de = new XPathException("Conversion of dayTimeDuration to " + target.getName() + " is not supported");
        de.setErrorCode("SXJE0007");
        throw de;
    }
}

