/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.Collator;
import java.text.RuleBasedCollator;
import java.util.Locale;
import java.util.Properties;
import org.apache.derby.iapi.db.DatabaseContext;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.i18n.LocaleFinder;
import org.apache.derby.iapi.services.io.RegisteredFormatIds;
import org.apache.derby.iapi.services.monitor.ModuleControl;
import org.apache.derby.iapi.services.monitor.ModuleFactory;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.types.BitDataValue;
import org.apache.derby.iapi.types.BooleanDataValue;
import org.apache.derby.iapi.types.CollatorSQLChar;
import org.apache.derby.iapi.types.CollatorSQLClob;
import org.apache.derby.iapi.types.CollatorSQLLongvarchar;
import org.apache.derby.iapi.types.CollatorSQLVarchar;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.DataValueFactory;
import org.apache.derby.iapi.types.DateTimeDataValue;
import org.apache.derby.iapi.types.NumberDataType;
import org.apache.derby.iapi.types.NumberDataValue;
import org.apache.derby.iapi.types.RefDataValue;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.iapi.types.SQLBit;
import org.apache.derby.iapi.types.SQLBlob;
import org.apache.derby.iapi.types.SQLBoolean;
import org.apache.derby.iapi.types.SQLChar;
import org.apache.derby.iapi.types.SQLClob;
import org.apache.derby.iapi.types.SQLDate;
import org.apache.derby.iapi.types.SQLDouble;
import org.apache.derby.iapi.types.SQLInteger;
import org.apache.derby.iapi.types.SQLLongVarbit;
import org.apache.derby.iapi.types.SQLLongint;
import org.apache.derby.iapi.types.SQLLongvarchar;
import org.apache.derby.iapi.types.SQLReal;
import org.apache.derby.iapi.types.SQLRef;
import org.apache.derby.iapi.types.SQLSmallint;
import org.apache.derby.iapi.types.SQLTime;
import org.apache.derby.iapi.types.SQLTimestamp;
import org.apache.derby.iapi.types.SQLTinyint;
import org.apache.derby.iapi.types.SQLVarbit;
import org.apache.derby.iapi.types.SQLVarchar;
import org.apache.derby.iapi.types.StringDataValue;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.iapi.types.UserDataValue;
import org.apache.derby.iapi.types.UserType;
import org.apache.derby.iapi.types.XML;
import org.apache.derby.iapi.types.XMLDataValue;
import org.apache.derby.impl.store.access.heap.HeapRowLocation;

abstract class DataValueFactoryImpl
implements DataValueFactory,
ModuleControl {
    LocaleFinder localeFinder;
    private Locale databaseLocale;
    private RuleBasedCollator collatorForCharacterTypes;

    DataValueFactoryImpl() {
    }

    public void boot(boolean bl, Properties properties) throws StandardException {
        int n;
        String string;
        DataValueDescriptor dataValueDescriptor;
        TypeId.decimalImplementation = dataValueDescriptor = this.getNullDecimal(null);
        RegisteredFormatIds.TwoByte[200] = dataValueDescriptor.getClass().getName();
        dataValueDescriptor = dataValueDescriptor.getNewNull();
        dataValueDescriptor.setValue(0L);
        NumberDataType.ZERO_DECIMAL = dataValueDescriptor;
        ModuleFactory moduleFactory = Monitor.getMonitor();
        this.databaseLocale = moduleFactory.getLocale(this);
        if (bl && (string = properties.getProperty("collation")) != null && (n = DataTypeDescriptor.getCollationType(string)) != 0) {
            if (n >= 1 && n < 5) {
                int n2 = n - 2;
                this.collatorForCharacterTypes = this.verifyCollatorSupport(n2);
            } else {
                throw StandardException.newException("XBM03.D", string);
            }
        }
    }

    public void stop() {
    }

    public NumberDataValue getDataValue(int n, NumberDataValue numberDataValue) throws StandardException {
        if (numberDataValue == null) {
            return new SQLInteger(n);
        }
        numberDataValue.setValue(n);
        return numberDataValue;
    }

    public NumberDataValue getDataValue(Integer n, NumberDataValue numberDataValue) throws StandardException {
        if (numberDataValue == null) {
            return new SQLInteger(n);
        }
        numberDataValue.setValue(n);
        return numberDataValue;
    }

    public NumberDataValue getDataValue(char c, NumberDataValue numberDataValue) throws StandardException {
        if (numberDataValue == null) {
            return new SQLInteger(c);
        }
        numberDataValue.setValue(c);
        return numberDataValue;
    }

    public NumberDataValue getDataValue(short s2, NumberDataValue numberDataValue) throws StandardException {
        if (numberDataValue == null) {
            return new SQLSmallint(s2);
        }
        numberDataValue.setValue(s2);
        return numberDataValue;
    }

    public NumberDataValue getDataValue(Short s2, NumberDataValue numberDataValue) throws StandardException {
        if (numberDataValue == null) {
            return new SQLSmallint(s2);
        }
        numberDataValue.setValue(s2);
        return numberDataValue;
    }

    public NumberDataValue getDataValue(byte by, NumberDataValue numberDataValue) throws StandardException {
        if (numberDataValue == null) {
            return new SQLTinyint(by);
        }
        numberDataValue.setValue(by);
        return numberDataValue;
    }

    public NumberDataValue getDataValue(Byte by, NumberDataValue numberDataValue) throws StandardException {
        if (numberDataValue == null) {
            return new SQLTinyint(by);
        }
        numberDataValue.setValue(by);
        return numberDataValue;
    }

    public NumberDataValue getDataValue(long l, NumberDataValue numberDataValue) throws StandardException {
        if (numberDataValue == null) {
            return new SQLLongint(l);
        }
        numberDataValue.setValue(l);
        return numberDataValue;
    }

    public NumberDataValue getDataValue(Long l, NumberDataValue numberDataValue) throws StandardException {
        if (numberDataValue == null) {
            return new SQLLongint(l);
        }
        numberDataValue.setValue(l);
        return numberDataValue;
    }

    public NumberDataValue getDataValue(float f, NumberDataValue numberDataValue) throws StandardException {
        if (numberDataValue == null) {
            return new SQLReal(f);
        }
        numberDataValue.setValue(f);
        return numberDataValue;
    }

    public NumberDataValue getDataValue(Float f, NumberDataValue numberDataValue) throws StandardException {
        if (numberDataValue == null) {
            return new SQLReal(f);
        }
        numberDataValue.setValue(f);
        return numberDataValue;
    }

    public NumberDataValue getDataValue(double d, NumberDataValue numberDataValue) throws StandardException {
        if (numberDataValue == null) {
            return new SQLDouble(d);
        }
        numberDataValue.setValue(d);
        return numberDataValue;
    }

    public NumberDataValue getDataValue(Double d, NumberDataValue numberDataValue) throws StandardException {
        if (numberDataValue == null) {
            return new SQLDouble(d);
        }
        numberDataValue.setValue(d);
        return numberDataValue;
    }

    public final NumberDataValue getDecimalDataValue(Number number) throws StandardException {
        NumberDataValue numberDataValue = this.getNullDecimal(null);
        numberDataValue.setValue(number);
        return numberDataValue;
    }

    public final NumberDataValue getDecimalDataValue(Number number, NumberDataValue numberDataValue) throws StandardException {
        if (numberDataValue == null) {
            return this.getDecimalDataValue(number);
        }
        numberDataValue.setValue(number);
        return numberDataValue;
    }

    public final NumberDataValue getDecimalDataValue(String string, NumberDataValue numberDataValue) throws StandardException {
        if (numberDataValue == null) {
            return this.getDecimalDataValue(string);
        }
        numberDataValue.setValue(string);
        return numberDataValue;
    }

    public BooleanDataValue getDataValue(boolean bl, BooleanDataValue booleanDataValue) throws StandardException {
        if (booleanDataValue == null) {
            return new SQLBoolean(bl);
        }
        booleanDataValue.setValue(bl);
        return booleanDataValue;
    }

    public BooleanDataValue getDataValue(Boolean bl, BooleanDataValue booleanDataValue) throws StandardException {
        if (booleanDataValue == null) {
            return new SQLBoolean(bl);
        }
        booleanDataValue.setValue(bl);
        return booleanDataValue;
    }

    public BitDataValue getBitDataValue(byte[] byArray) throws StandardException {
        return new SQLBit(byArray);
    }

    public BitDataValue getBitDataValue(byte[] byArray, BitDataValue bitDataValue) throws StandardException {
        if (bitDataValue == null) {
            return new SQLBit(byArray);
        }
        bitDataValue.setValue(byArray);
        return bitDataValue;
    }

    public BitDataValue getVarbitDataValue(byte[] byArray, BitDataValue bitDataValue) throws StandardException {
        if (bitDataValue == null) {
            return new SQLVarbit(byArray);
        }
        bitDataValue.setValue(byArray);
        return bitDataValue;
    }

    public BitDataValue getLongVarbitDataValue(byte[] byArray, BitDataValue bitDataValue) throws StandardException {
        if (bitDataValue == null) {
            return new SQLLongVarbit(byArray);
        }
        bitDataValue.setValue(byArray);
        return bitDataValue;
    }

    public BitDataValue getBlobDataValue(byte[] byArray, BitDataValue bitDataValue) throws StandardException {
        if (bitDataValue == null) {
            return new SQLBlob(byArray);
        }
        bitDataValue.setValue(byArray);
        return bitDataValue;
    }

    public BitDataValue getBlobDataValue(Blob blob, BitDataValue bitDataValue) throws StandardException {
        if (bitDataValue == null) {
            return new SQLBlob(blob);
        }
        bitDataValue.setValue(blob);
        return bitDataValue;
    }

    public StringDataValue getCharDataValue(String string) {
        return new SQLChar(string);
    }

    public StringDataValue getCharDataValue(String string, StringDataValue stringDataValue) throws StandardException {
        if (stringDataValue == null) {
            return new SQLChar(string);
        }
        stringDataValue.setValue(string);
        return stringDataValue;
    }

    public StringDataValue getCharDataValue(String string, StringDataValue stringDataValue, int n) throws StandardException {
        if (n == 0) {
            return this.getCharDataValue(string, stringDataValue);
        }
        if (stringDataValue == null) {
            return new CollatorSQLChar(string, this.getCharacterCollator(n));
        }
        stringDataValue.setValue(string);
        return stringDataValue;
    }

    public StringDataValue getVarcharDataValue(String string) {
        return new SQLVarchar(string);
    }

    public StringDataValue getVarcharDataValue(String string, StringDataValue stringDataValue) throws StandardException {
        if (stringDataValue == null) {
            return new SQLVarchar(string);
        }
        stringDataValue.setValue(string);
        return stringDataValue;
    }

    public StringDataValue getVarcharDataValue(String string, StringDataValue stringDataValue, int n) throws StandardException {
        if (n == 0) {
            return this.getVarcharDataValue(string, stringDataValue);
        }
        if (stringDataValue == null) {
            return new CollatorSQLVarchar(string, this.getCharacterCollator(n));
        }
        stringDataValue.setValue(string);
        return stringDataValue;
    }

    public StringDataValue getLongvarcharDataValue(String string) {
        return new SQLLongvarchar(string);
    }

    public StringDataValue getLongvarcharDataValue(String string, StringDataValue stringDataValue) throws StandardException {
        if (stringDataValue == null) {
            return new SQLLongvarchar(string);
        }
        stringDataValue.setValue(string);
        return stringDataValue;
    }

    public StringDataValue getLongvarcharDataValue(String string, StringDataValue stringDataValue, int n) throws StandardException {
        if (n == 0) {
            return this.getLongvarcharDataValue(string, stringDataValue);
        }
        if (stringDataValue == null) {
            return new CollatorSQLLongvarchar(string, this.getCharacterCollator(n));
        }
        stringDataValue.setValue(string);
        return stringDataValue;
    }

    public StringDataValue getClobDataValue(String string, StringDataValue stringDataValue) throws StandardException {
        if (stringDataValue == null) {
            return new SQLClob(string);
        }
        stringDataValue.setValue(string);
        return stringDataValue;
    }

    public StringDataValue getClobDataValue(Clob clob, StringDataValue stringDataValue) throws StandardException {
        if (stringDataValue == null) {
            return new SQLClob(clob);
        }
        stringDataValue.setValue(clob);
        return stringDataValue;
    }

    public StringDataValue getClobDataValue(Clob clob, StringDataValue stringDataValue, int n) throws StandardException {
        if (n == 0) {
            return this.getClobDataValue(clob, stringDataValue);
        }
        if (stringDataValue == null) {
            return new CollatorSQLClob(clob, this.getCharacterCollator(n));
        }
        stringDataValue.setValue(clob);
        return stringDataValue;
    }

    public StringDataValue getClobDataValue(String string, StringDataValue stringDataValue, int n) throws StandardException {
        if (n == 0) {
            return this.getClobDataValue(string, stringDataValue);
        }
        if (stringDataValue == null) {
            return new CollatorSQLClob(string, this.getCharacterCollator(n));
        }
        stringDataValue.setValue(string);
        return stringDataValue;
    }

    public DateTimeDataValue getDataValue(Date date, DateTimeDataValue dateTimeDataValue) throws StandardException {
        if (dateTimeDataValue == null) {
            return new SQLDate(date);
        }
        dateTimeDataValue.setValue(date);
        return dateTimeDataValue;
    }

    public DateTimeDataValue getDataValue(Time time, DateTimeDataValue dateTimeDataValue) throws StandardException {
        if (dateTimeDataValue == null) {
            return new SQLTime(time);
        }
        dateTimeDataValue.setValue(time);
        return dateTimeDataValue;
    }

    public DateTimeDataValue getDataValue(Timestamp timestamp, DateTimeDataValue dateTimeDataValue) throws StandardException {
        if (dateTimeDataValue == null) {
            return new SQLTimestamp(timestamp);
        }
        dateTimeDataValue.setValue(timestamp);
        return dateTimeDataValue;
    }

    public DateTimeDataValue getDate(DataValueDescriptor dataValueDescriptor) throws StandardException {
        return SQLDate.computeDateFunction(dataValueDescriptor, this);
    }

    public DateTimeDataValue getTimestamp(DataValueDescriptor dataValueDescriptor) throws StandardException {
        return SQLTimestamp.computeTimestampFunction(dataValueDescriptor, this);
    }

    public DateTimeDataValue getTimestamp(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        return new SQLTimestamp(dataValueDescriptor, dataValueDescriptor2);
    }

    public UserDataValue getDataValue(Object object, UserDataValue userDataValue) {
        if (userDataValue == null) {
            return new UserType(object);
        }
        ((UserType)userDataValue).setValue(object);
        return userDataValue;
    }

    public RefDataValue getDataValue(RowLocation rowLocation, RefDataValue refDataValue) {
        if (refDataValue == null) {
            return new SQLRef(rowLocation);
        }
        refDataValue.setValue(rowLocation);
        return refDataValue;
    }

    public NumberDataValue getNullInteger(NumberDataValue numberDataValue) {
        if (numberDataValue == null) {
            return new SQLInteger();
        }
        numberDataValue.setToNull();
        return numberDataValue;
    }

    public NumberDataValue getNullShort(NumberDataValue numberDataValue) {
        if (numberDataValue == null) {
            return new SQLSmallint();
        }
        numberDataValue.setToNull();
        return numberDataValue;
    }

    public NumberDataValue getNullLong(NumberDataValue numberDataValue) {
        if (numberDataValue == null) {
            return new SQLLongint();
        }
        numberDataValue.setToNull();
        return numberDataValue;
    }

    public NumberDataValue getNullByte(NumberDataValue numberDataValue) {
        if (numberDataValue == null) {
            return new SQLTinyint();
        }
        numberDataValue.setToNull();
        return numberDataValue;
    }

    public NumberDataValue getNullFloat(NumberDataValue numberDataValue) {
        if (numberDataValue == null) {
            return new SQLReal();
        }
        numberDataValue.setToNull();
        return numberDataValue;
    }

    public NumberDataValue getNullDouble(NumberDataValue numberDataValue) {
        if (numberDataValue == null) {
            return new SQLDouble();
        }
        numberDataValue.setToNull();
        return numberDataValue;
    }

    public BooleanDataValue getNullBoolean(BooleanDataValue booleanDataValue) {
        if (booleanDataValue == null) {
            return new SQLBoolean();
        }
        booleanDataValue.setToNull();
        return booleanDataValue;
    }

    public BitDataValue getNullBit(BitDataValue bitDataValue) throws StandardException {
        if (bitDataValue == null) {
            return this.getBitDataValue(null);
        }
        bitDataValue.setToNull();
        return bitDataValue;
    }

    public BitDataValue getNullVarbit(BitDataValue bitDataValue) throws StandardException {
        if (bitDataValue == null) {
            return new SQLVarbit();
        }
        bitDataValue.setToNull();
        return bitDataValue;
    }

    public BitDataValue getNullLongVarbit(BitDataValue bitDataValue) throws StandardException {
        if (bitDataValue == null) {
            return new SQLLongVarbit();
        }
        bitDataValue.setToNull();
        return bitDataValue;
    }

    public BitDataValue getNullBlob(BitDataValue bitDataValue) throws StandardException {
        if (bitDataValue == null) {
            return new SQLBlob();
        }
        bitDataValue.setToNull();
        return bitDataValue;
    }

    public StringDataValue getNullChar(StringDataValue stringDataValue) {
        if (stringDataValue == null) {
            return this.getCharDataValue(null);
        }
        stringDataValue.setToNull();
        return stringDataValue;
    }

    public StringDataValue getNullChar(StringDataValue stringDataValue, int n) throws StandardException {
        if (n == 0) {
            return this.getNullChar(stringDataValue);
        }
        if (stringDataValue == null) {
            return new CollatorSQLChar(this.getCharacterCollator(n));
        }
        stringDataValue.setToNull();
        return stringDataValue;
    }

    public StringDataValue getNullVarchar(StringDataValue stringDataValue) {
        if (stringDataValue == null) {
            return this.getVarcharDataValue(null);
        }
        stringDataValue.setToNull();
        return stringDataValue;
    }

    public StringDataValue getNullVarchar(StringDataValue stringDataValue, int n) throws StandardException {
        if (n == 0) {
            return this.getNullChar(stringDataValue);
        }
        if (stringDataValue == null) {
            return new CollatorSQLVarchar(this.getCharacterCollator(n));
        }
        stringDataValue.setToNull();
        return stringDataValue;
    }

    public StringDataValue getNullLongvarchar(StringDataValue stringDataValue) {
        if (stringDataValue == null) {
            return this.getLongvarcharDataValue(null);
        }
        stringDataValue.setToNull();
        return stringDataValue;
    }

    public StringDataValue getNullLongvarchar(StringDataValue stringDataValue, int n) throws StandardException {
        if (n == 0) {
            return this.getNullChar(stringDataValue);
        }
        if (stringDataValue == null) {
            return new CollatorSQLLongvarchar(this.getCharacterCollator(n));
        }
        stringDataValue.setToNull();
        return stringDataValue;
    }

    public StringDataValue getNullClob(StringDataValue stringDataValue) {
        if (stringDataValue == null) {
            return new SQLClob();
        }
        stringDataValue.setToNull();
        return stringDataValue;
    }

    public StringDataValue getNullClob(StringDataValue stringDataValue, int n) throws StandardException {
        if (n == 0) {
            return this.getNullChar(stringDataValue);
        }
        if (stringDataValue == null) {
            return new CollatorSQLClob(this.getCharacterCollator(n));
        }
        stringDataValue.setToNull();
        return stringDataValue;
    }

    public UserDataValue getNullObject(UserDataValue userDataValue) {
        if (userDataValue == null) {
            return new UserType(null);
        }
        userDataValue.setToNull();
        return userDataValue;
    }

    public RefDataValue getNullRef(RefDataValue refDataValue) {
        if (refDataValue == null) {
            return new SQLRef();
        }
        refDataValue.setToNull();
        return refDataValue;
    }

    public DateTimeDataValue getNullDate(DateTimeDataValue dateTimeDataValue) {
        if (dateTimeDataValue == null) {
            try {
                return new SQLDate(null);
            }
            catch (StandardException standardException) {
                return null;
            }
        }
        dateTimeDataValue.setToNull();
        return dateTimeDataValue;
    }

    public DateTimeDataValue getNullTime(DateTimeDataValue dateTimeDataValue) {
        if (dateTimeDataValue == null) {
            try {
                return new SQLTime(null);
            }
            catch (StandardException standardException) {
                return null;
            }
        }
        dateTimeDataValue.setToNull();
        return dateTimeDataValue;
    }

    public DateTimeDataValue getNullTimestamp(DateTimeDataValue dateTimeDataValue) {
        if (dateTimeDataValue == null) {
            try {
                return new SQLTimestamp(null);
            }
            catch (StandardException standardException) {
                return null;
            }
        }
        dateTimeDataValue.setToNull();
        return dateTimeDataValue;
    }

    public DateTimeDataValue getDateValue(String string, boolean bl) throws StandardException {
        return new SQLDate(string, bl, this.getLocaleFinder());
    }

    public DateTimeDataValue getTimeValue(String string, boolean bl) throws StandardException {
        return new SQLTime(string, bl, this.getLocaleFinder());
    }

    public DateTimeDataValue getTimestampValue(String string, boolean bl) throws StandardException {
        return new SQLTimestamp(string, bl, this.getLocaleFinder());
    }

    public XMLDataValue getXMLDataValue(XMLDataValue xMLDataValue) throws StandardException {
        return this.getNullXML(xMLDataValue);
    }

    public XMLDataValue getNullXML(XMLDataValue xMLDataValue) {
        if (xMLDataValue == null) {
            return new XML();
        }
        xMLDataValue.setToNull();
        return xMLDataValue;
    }

    public RuleBasedCollator getCharacterCollator(int n) throws StandardException {
        if (n == 0) {
            return null;
        }
        if (this.collatorForCharacterTypes == null) {
            int n2 = n - 2;
            this.collatorForCharacterTypes = this.verifyCollatorSupport(n2);
            return this.collatorForCharacterTypes;
        }
        return this.collatorForCharacterTypes;
    }

    private RuleBasedCollator verifyCollatorSupport(int n) throws StandardException {
        Locale[] localeArray = Collator.getAvailableLocales();
        boolean bl = false;
        for (int i = 0; i < localeArray.length; ++i) {
            if (!localeArray[i].equals(this.databaseLocale)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            throw StandardException.newException("XBM04.D", this.databaseLocale.toString());
        }
        RuleBasedCollator ruleBasedCollator = (RuleBasedCollator)Collator.getInstance(this.databaseLocale);
        if (n != -1) {
            ruleBasedCollator.setStrength(n);
        }
        return ruleBasedCollator;
    }

    public DataValueDescriptor getNull(int n, int n2) throws StandardException {
        if (n == 200) {
            return this.getNullDecimal(null);
        }
        DataValueDescriptor dataValueDescriptor = DataValueFactoryImpl.getNullDVDWithUCS_BASICcollation(n);
        if (n2 == 0) {
            return dataValueDescriptor;
        }
        if (dataValueDescriptor instanceof StringDataValue) {
            return ((StringDataValue)dataValueDescriptor).getValue(this.getCharacterCollator(n2));
        }
        return dataValueDescriptor;
    }

    public static DataValueDescriptor getNullDVDWithUCS_BASICcollation(int n) {
        switch (n) {
            case 87: {
                return new SQLBit();
            }
            case 77: {
                return new SQLBoolean();
            }
            case 78: {
                return new SQLChar();
            }
            case 298: {
                return new SQLDate();
            }
            case 79: {
                return new SQLDouble();
            }
            case 80: {
                return new SQLInteger();
            }
            case 84: {
                return new SQLLongint();
            }
            case 81: {
                return new SQLReal();
            }
            case 82: {
                return new SQLRef();
            }
            case 83: {
                return new SQLSmallint();
            }
            case 299: {
                return new SQLTime();
            }
            case 31: {
                return new SQLTimestamp();
            }
            case 199: {
                return new SQLTinyint();
            }
            case 85: {
                return new SQLVarchar();
            }
            case 235: {
                return new SQLLongvarchar();
            }
            case 88: {
                return new SQLVarbit();
            }
            case 234: {
                return new SQLLongVarbit();
            }
            case 266: {
                return new UserType();
            }
            case 443: {
                return new SQLBlob();
            }
            case 447: {
                return new SQLClob();
            }
            case 458: {
                return new XML();
            }
            case 90: {
                return new HeapRowLocation();
            }
        }
        return null;
    }

    private LocaleFinder getLocaleFinder() {
        DatabaseContext databaseContext;
        if (this.localeFinder == null && (databaseContext = (DatabaseContext)ContextService.getContext("Database")) != null) {
            this.localeFinder = databaseContext.getDatabase();
        }
        return this.localeFinder;
    }
}

