/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.load;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import org.apache.derby.iapi.error.PublicAPI;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.util.IdUtil;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.load.ColumnInfo;
import org.apache.derby.impl.load.ControlInfo;
import org.apache.derby.impl.load.ImportAbstract;
import org.apache.derby.impl.load.ImportReadData;
import org.apache.derby.impl.load.LoadError;

public class Import
extends ImportAbstract {
    private static int _importCounter;
    private static Hashtable _importers;
    private String inputFileName;

    public Import(String string, String string2, String string3, String string4, int n, String string5, boolean bl, int n2, String string6, String string7) throws SQLException {
        try {
            this.inputFileName = string;
            this.noOfColumnsExpected = n;
            this.tableColumnTypesStr = string5;
            this.columnTypeNamesString = string6;
            this.udtClassNamesString = string7;
            this.controlFileReader = new ControlInfo();
            this.controlFileReader.setControlProperties(string3, string2, string4);
            this.lobsInExtFile = bl;
            _importers.put(new Integer(n2), this);
            this.doImport();
        }
        catch (Exception exception) {
            throw this.importError(exception);
        }
    }

    private void doImport() throws Exception {
        if (this.inputFileName == null) {
            throw LoadError.dataFileNull();
        }
        this.doAllTheWork();
    }

    public static void importTable(Connection connection, String string, String string2, String string3, String string4, String string5, String string6, short s2, boolean bl) throws SQLException {
        Import.performImport(connection, string, null, null, string2, string3, string4, string5, string6, s2, bl);
    }

    public static void importData(Connection connection, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, short s2, boolean bl) throws SQLException {
        Import.performImport(connection, string, string3, string4, string2, string5, string6, string7, string8, s2, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void performImport(Connection connection, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, short s2, boolean bl) throws SQLException {
        Integer n = new Integer(Import.bumpImportCounter());
        try {
            if (connection == null) {
                throw LoadError.connectionNull();
            }
            if (string4 == null) {
                throw LoadError.entityNameMissing();
            }
            ColumnInfo columnInfo = new ColumnInfo(connection, string, string4, string2, string3, "COLUMN");
            String string9 = null;
            String string10 = null;
            try {
                string9 = columnInfo.getColumnTypeNames();
                string10 = columnInfo.getUDTClassNames();
            }
            catch (Throwable throwable) {
                throw Import.formatImportError((Import)_importers.get(n), string5, throwable);
            }
            StringBuffer stringBuffer = new StringBuffer("new ");
            stringBuffer.append("org.apache.derby.impl.load.Import");
            stringBuffer.append("(");
            stringBuffer.append(Import.quoteStringArgument(string5));
            stringBuffer.append(",");
            stringBuffer.append(Import.quoteStringArgument(string6));
            stringBuffer.append(",");
            stringBuffer.append(Import.quoteStringArgument(string7));
            stringBuffer.append(",");
            stringBuffer.append(Import.quoteStringArgument(string8));
            stringBuffer.append(", ");
            stringBuffer.append(columnInfo.getExpectedNumberOfColumnsInFile());
            stringBuffer.append(", ");
            stringBuffer.append(Import.quoteStringArgument(columnInfo.getExpectedVtiColumnTypesAsString()));
            stringBuffer.append(", ");
            stringBuffer.append(bl);
            stringBuffer.append(", ");
            stringBuffer.append(n);
            stringBuffer.append(", ");
            stringBuffer.append(Import.quoteStringArgument(string9));
            stringBuffer.append(", ");
            stringBuffer.append(Import.quoteStringArgument(string10));
            stringBuffer.append(" )");
            String string11 = stringBuffer.toString();
            String string12 = IdUtil.mkQualifiedName(string, string4);
            String string13 = s2 > 0 ? "replace" : "bulkInsert";
            String string14 = columnInfo.getColumnNamesWithCasts();
            String string15 = columnInfo.getInsertColumnNames();
            string15 = string15 != null ? "(" + string15 + ") " : "";
            String string16 = "INSERT INTO " + string12 + string15 + " --DERBY-PROPERTIES insertMode=" + string13 + "\n" + " SELECT " + string14 + " from " + string11 + " AS importvti";
            PreparedStatement preparedStatement = connection.prepareStatement(string16);
            Statement statement = connection.createStatement();
            String string17 = "LOCK TABLE " + string12 + " IN EXCLUSIVE MODE";
            statement.executeUpdate(string17);
            try {
                preparedStatement.executeUpdate();
            }
            catch (Throwable throwable) {
                throw Import.formatImportError((Import)_importers.get(n), string5, throwable);
            }
            statement.close();
            preparedStatement.close();
        }
        finally {
            _importers.remove(n);
        }
    }

    ImportReadData getImportReadData() throws Exception {
        return new ImportReadData(this.inputFileName, this.controlFileReader);
    }

    private static synchronized int bumpImportCounter() {
        return ++_importCounter;
    }

    private static SQLException formatImportError(Import import_, String string, Throwable throwable) {
        int n = -1;
        if (import_ != null) {
            n = import_.getCurrentLineNumber();
        }
        StandardException standardException = StandardException.newException("XIE0R.S", (Object)new Integer(n), (Object)string, (Object)throwable.getMessage());
        standardException.initCause(throwable);
        return PublicAPI.wrapStandardException(standardException);
    }

    private static String quoteStringArgument(String string) {
        if (string == null) {
            return "NULL";
        }
        return StringUtil.quoteStringLiteral(string);
    }

    static {
        _importers = new Hashtable();
    }
}

