/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit;

import java.util.EnumSet;
import org.geotoolkit.factory.AuthorityFactoryFinder;
import org.geotoolkit.factory.FactoryNotFoundException;
import org.geotoolkit.factory.Hints;
import org.geotoolkit.referencing.CRS;
import org.geotoolkit.referencing.IdentifiedObjects;
import org.geotoolkit.referencing.factory.epsg.ThreadedEpsgFactory;
import org.geotoolkit.referencing.operation.transform.AbstractMathTransform;
import org.geotoolkit.referencing.operation.transform.ConcatenatedTransform;
import org.geotoolkit.util.logging.Logging;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.referencing.AuthorityFactory;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.cs.CSAuthorityFactory;
import org.opengis.referencing.cs.CSFactory;
import org.opengis.referencing.datum.DatumAuthorityFactory;
import org.opengis.referencing.datum.DatumFactory;
import org.opengis.referencing.operation.CoordinateOperationAuthorityFactory;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.test.CalculationType;
import org.opengis.test.Configuration;
import org.opengis.test.FactoryFilter;
import org.opengis.test.ImplementationDetails;
import org.opengis.test.TestSuite;
import org.opengis.test.ToleranceModifier;
import org.opengis.test.ToleranceModifiers;
import org.opengis.util.Factory;
import org.opengis.util.NameFactory;

public strictfp final class GeoapiTest
extends TestSuite
implements ImplementationDetails,
FactoryFilter {
    private static Boolean isEpsgFactoryAvailable;

    public <T extends Factory> boolean filter(Class<T> clazz, T t) {
        if (!t.getClass().getName().startsWith("org.geotoolkit.")) {
            return false;
        }
        if (!AuthorityFactory.class.isAssignableFrom(clazz)) {
            return true;
        }
        if (isEpsgFactoryAvailable == null) {
            Hints hints = new Hints(Hints.CRS_AUTHORITY_FACTORY, ThreadedEpsgFactory.class);
            try {
                AuthorityFactoryFinder.getCRSAuthorityFactory("EPSG", hints);
                isEpsgFactoryAvailable = Boolean.TRUE;
            }
            catch (FactoryNotFoundException factoryNotFoundException) {
                isEpsgFactoryAvailable = Boolean.FALSE;
            }
        }
        return isEpsgFactoryAvailable;
    }

    public Configuration configuration(Factory ... factoryArray) {
        return null;
    }

    public ToleranceModifier tolerance(MathTransform mathTransform) {
        return GeoapiTest.tolerance(mathTransform, true);
    }

    private static ToleranceModifier tolerance(MathTransform mathTransform, boolean bl) {
        while (mathTransform instanceof AbstractMathTransform) {
            ParameterDescriptorGroup parameterDescriptorGroup = ((AbstractMathTransform)mathTransform).getParameterDescriptors();
            if (parameterDescriptorGroup != null) {
                if (IdentifiedObjects.nameMatches((IdentifiedObject)parameterDescriptorGroup, "Abridged_Molodenski")) {
                    return ToleranceModifiers.scale(EnumSet.of(CalculationType.DIRECT_TRANSFORM, CalculationType.INVERSE_TRANSFORM), (double[])new double[]{2.0, 2.0, 2.0});
                }
                if (IdentifiedObjects.nameMatches((IdentifiedObject)parameterDescriptorGroup, "Lambert_Azimuthal_Equal_Area")) {
                    return ToleranceModifiers.scale(EnumSet.of(CalculationType.INVERSE_TRANSFORM), (double[])new double[]{bl ? 1.0 : 5.0, 5.0});
                }
                if (IdentifiedObjects.nameMatches((IdentifiedObject)parameterDescriptorGroup, "Cassini_Soldner")) {
                    if (bl) {
                        return ToleranceModifiers.maximum((ToleranceModifier[])new ToleranceModifier[]{ToleranceModifiers.scale(EnumSet.of(CalculationType.DIRECT_TRANSFORM), (double[])new double[]{1.0, 5.0}), ToleranceModifiers.scale(EnumSet.of(CalculationType.INVERSE_TRANSFORM), (double[])new double[]{2.0, 100.0})});
                    }
                    return ToleranceModifiers.scale(EnumSet.of(CalculationType.DIRECT_TRANSFORM, CalculationType.INVERSE_TRANSFORM), (double[])new double[]{250.0, 250.0});
                }
            }
            if (!(mathTransform instanceof ConcatenatedTransform)) break;
            ConcatenatedTransform concatenatedTransform = (ConcatenatedTransform)mathTransform;
            ToleranceModifier toleranceModifier = GeoapiTest.tolerance(concatenatedTransform.transform1, false);
            if (toleranceModifier != null) {
                return toleranceModifier;
            }
            mathTransform = concatenatedTransform.transform2;
            bl = false;
        }
        return null;
    }

    static {
        Logging.GEOTOOLKIT.forceMonolineConsoleOutput(null);
        GeoapiTest.setFactories(NameFactory.class, (Factory[])new NameFactory[]{AuthorityFactoryFinder.getNameFactory(null)});
        GeoapiTest.setFactories(CSFactory.class, (Factory[])new CSFactory[]{AuthorityFactoryFinder.getCSFactory(null)});
        GeoapiTest.setFactories(CRSFactory.class, (Factory[])new CRSFactory[]{AuthorityFactoryFinder.getCRSFactory(null)});
        GeoapiTest.setFactories(DatumFactory.class, (Factory[])new DatumFactory[]{AuthorityFactoryFinder.getDatumFactory(null)});
        GeoapiTest.setFactories(MathTransformFactory.class, (Factory[])new MathTransformFactory[]{AuthorityFactoryFinder.getMathTransformFactory(null)});
        GeoapiTest.setFactories(CoordinateOperationFactory.class, (Factory[])new CoordinateOperationFactory[]{CRS.getCoordinateOperationFactory(false)});
        GeoapiTest.setFactories(CRSAuthorityFactory.class, (Factory[])new CRSAuthorityFactory[]{CRS.getAuthorityFactory(false)});
        try {
            GeoapiTest.setFactories(CSAuthorityFactory.class, (Factory[])new CSAuthorityFactory[]{AuthorityFactoryFinder.getCSAuthorityFactory("EPSG", null)});
            GeoapiTest.setFactories(DatumAuthorityFactory.class, (Factory[])new DatumAuthorityFactory[]{AuthorityFactoryFinder.getDatumAuthorityFactory("EPSG", null)});
            GeoapiTest.setFactories(CoordinateOperationAuthorityFactory.class, (Factory[])new CoordinateOperationAuthorityFactory[]{AuthorityFactoryFinder.getCoordinateOperationAuthorityFactory("EPSG", null)});
        }
        catch (FactoryNotFoundException factoryNotFoundException) {
            Logging.getLogger(GeoapiTest.class).warning(factoryNotFoundException.getLocalizedMessage());
            GeoapiTest.setFactories(CSAuthorityFactory.class, (Factory[])new CSAuthorityFactory[0]);
            GeoapiTest.setFactories(DatumAuthorityFactory.class, (Factory[])new DatumAuthorityFactory[0]);
            GeoapiTest.setFactories(CoordinateOperationAuthorityFactory.class, (Factory[])new CoordinateOperationAuthorityFactory[0]);
        }
    }
}

