/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.display.shape;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import net.jcip.annotations.NotThreadSafe;
import org.geotoolkit.display.shape.ProjectedPathIterator;
import org.geotoolkit.display.shape.TransformedShape;
import org.geotoolkit.display.shape.XRectangle2D;
import org.geotoolkit.geometry.Envelopes;
import org.geotoolkit.referencing.operation.MathTransforms;
import org.geotoolkit.referencing.operation.transform.AffineTransform2D;
import org.geotoolkit.util.ArgumentChecks;
import org.geotoolkit.util.logging.Logging;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;

@NotThreadSafe
public class ProjectedShape
implements Shape,
Serializable {
    private static final long serialVersionUID = -583674918489345612L;
    protected final Shape shape;
    protected final MathTransform2D projection;
    private transient MathTransform2D inverse;
    private transient Point2D.Double point;
    private transient Rectangle2D.Double rectangle;

    protected ProjectedShape(Shape shape, MathTransform2D mathTransform2D) {
        ArgumentChecks.ensureNonNull("shape", shape);
        ArgumentChecks.ensureNonNull("projection", mathTransform2D);
        this.shape = shape;
        this.projection = mathTransform2D;
    }

    public static Shape wrap(Shape shape, MathTransform2D mathTransform2D) {
        if (mathTransform2D == null || mathTransform2D.isIdentity()) {
            return shape;
        }
        if (mathTransform2D instanceof AffineTransform) {
            return new TransformedShape(shape, (AffineTransform)((Object)mathTransform2D));
        }
        return new ProjectedShape(shape, mathTransform2D);
    }

    private MathTransform2D inverse() throws NoninvertibleTransformException {
        if (this.inverse == null) {
            this.inverse = this.projection.inverse();
            if (this.point == null) {
                this.point = new Point2D.Double();
            }
            if (this.rectangle == null) {
                this.rectangle = new Rectangle2D.Double();
            }
        }
        return this.inverse;
    }

    @Override
    public boolean contains(double d, double d2) {
        Point2D.Double double_ = this.point;
        if (double_ == null) {
            this.point = double_ = new Point2D.Double();
        }
        double_.x = d;
        double_.y = d2;
        return this.contains(double_);
    }

    @Override
    public boolean contains(Point2D point2D) {
        try {
            return this.shape.contains(this.inverse().transform(point2D, this.point));
        }
        catch (TransformException transformException) {
            Logging.recoverableException(ProjectedShape.class, "contains", transformException);
            return false;
        }
    }

    @Override
    public boolean contains(double d, double d2, double d3, double d4) {
        Rectangle2D.Double double_ = this.rectangle;
        if (double_ == null) {
            this.rectangle = double_ = new Rectangle2D.Double();
        }
        double_.x = d;
        double_.y = d2;
        double_.width = d3;
        double_.height = d4;
        return this.contains(double_);
    }

    @Override
    public boolean contains(Rectangle2D rectangle2D) {
        try {
            return this.shape.contains(Envelopes.transform(this.inverse(), rectangle2D, (Rectangle2D)this.rectangle));
        }
        catch (TransformException transformException) {
            Logging.recoverableException(ProjectedShape.class, "contains", transformException);
            return false;
        }
    }

    @Override
    public boolean intersects(double d, double d2, double d3, double d4) {
        Rectangle2D.Double double_ = this.rectangle;
        if (double_ == null) {
            this.rectangle = double_ = new Rectangle2D.Double();
        }
        double_.x = d;
        double_.y = d2;
        double_.width = d3;
        double_.height = d4;
        return this.intersects(double_);
    }

    @Override
    public boolean intersects(Rectangle2D rectangle2D) {
        try {
            return this.shape.intersects(Envelopes.transform(this.inverse(), rectangle2D, (Rectangle2D)this.rectangle));
        }
        catch (TransformException transformException) {
            Logging.recoverableException(ProjectedShape.class, "intersects", transformException);
            return true;
        }
    }

    @Override
    public Rectangle getBounds() {
        Rectangle rectangle = new Rectangle();
        rectangle.setRect(rectangle);
        return rectangle;
    }

    @Override
    public Rectangle2D getBounds2D() {
        try {
            return Envelopes.transform(this.projection, this.shape.getBounds2D(), null);
        }
        catch (TransformException transformException) {
            Logging.recoverableException(ProjectedShape.class, "getBounds2D", transformException);
            return XRectangle2D.INFINITY;
        }
    }

    private MathTransform2D concatenate(AffineTransform affineTransform) {
        MathTransform2D mathTransform2D = this.projection;
        if (affineTransform != null && !affineTransform.isIdentity()) {
            mathTransform2D = MathTransforms.concatenate(mathTransform2D, new AffineTransform2D(affineTransform));
        }
        return mathTransform2D;
    }

    @Override
    public PathIterator getPathIterator(AffineTransform affineTransform) {
        MathTransform2D mathTransform2D = this.concatenate(affineTransform);
        if (mathTransform2D.isIdentity()) {
            return this.shape.getPathIterator(affineTransform);
        }
        return new ProjectedPathIterator(this.shape.getPathIterator(null), mathTransform2D);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform affineTransform, double d) {
        MathTransform2D mathTransform2D = this.concatenate(affineTransform);
        if (mathTransform2D.isIdentity()) {
            return this.shape.getPathIterator(affineTransform, d);
        }
        return new FlatteningPathIterator(new ProjectedPathIterator(this.shape.getPathIterator(null), mathTransform2D), d);
    }

    public int hashCode() {
        return this.shape.hashCode() ^ this.projection.hashCode() ^ 0xB2331B4;
    }

    public boolean equals(Object object) {
        if (object instanceof ProjectedShape) {
            ProjectedShape projectedShape = (ProjectedShape)object;
            return this.shape.equals(projectedShape.shape) && this.projection.equals(projectedShape.projection);
        }
        return false;
    }
}

