/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.internal.referencing;

import java.awt.geom.Rectangle2D;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.geotoolkit.factory.Factories;
import org.geotoolkit.factory.FactoryFinder;
import org.geotoolkit.factory.Hints;
import org.geotoolkit.geometry.Envelopes;
import org.geotoolkit.internal.InternalUtilities;
import org.geotoolkit.internal.referencing.CRSUtilities;
import org.geotoolkit.internal.referencing.ProxyForMetadata;
import org.geotoolkit.metadata.iso.extent.AbstractGeographicExtent;
import org.geotoolkit.metadata.iso.extent.DefaultExtent;
import org.geotoolkit.metadata.iso.extent.DefaultGeographicBoundingBox;
import org.geotoolkit.metadata.iso.extent.DefaultTemporalExtent;
import org.geotoolkit.metadata.iso.extent.DefaultVerticalExtent;
import org.geotoolkit.referencing.CRS;
import org.geotoolkit.referencing.crs.DefaultGeographicCRS;
import org.geotoolkit.referencing.crs.DefaultTemporalCRS;
import org.geotoolkit.referencing.operation.TransformPathNotFoundException;
import org.geotoolkit.resources.Errors;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.extent.GeographicExtent;
import org.opengis.metadata.extent.VerticalExtent;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public final class ProxyForMetadataImpl
extends ProxyForMetadata
implements ChangeListener {
    private CoordinateOperationFactory factory;

    ProxyForMetadataImpl() {
        Factories.addChangeListener(this);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.factory = null;
    }

    private CoordinateOperationFactory getFactory() {
        if (this.factory == null) {
            Hints hints = new Hints(Hints.LENIENT_DATUM_SHIFT, Boolean.TRUE);
            this.factory = FactoryFinder.getCoordinateOperationFactory(hints);
        }
        return this.factory;
    }

    @Override
    public void copy(Rectangle2D rectangle2D, CoordinateReferenceSystem coordinateReferenceSystem, DefaultGeographicBoundingBox defaultGeographicBoundingBox) throws TransformException {
        if (coordinateReferenceSystem != null) {
            if ((coordinateReferenceSystem = CRS.getHorizontalCRS(coordinateReferenceSystem)) == null) {
                throw new TransformPathNotFoundException(Errors.format(77));
            }
            GeographicCRS geographicCRS = CRSUtilities.getStandardGeographicCRS2D(coordinateReferenceSystem);
            if (!CRS.equalsIgnoreMetadata(coordinateReferenceSystem, geographicCRS)) {
                CoordinateOperation coordinateOperation;
                try {
                    coordinateOperation = this.getFactory().createOperation(coordinateReferenceSystem, geographicCRS);
                }
                catch (FactoryException factoryException) {
                    throw new TransformPathNotFoundException(factoryException);
                }
                rectangle2D = Envelopes.transform(coordinateOperation, rectangle2D, null);
            }
        }
        defaultGeographicBoundingBox.setBounds(rectangle2D);
    }

    @Override
    public void copy(Envelope envelope, DefaultGeographicBoundingBox defaultGeographicBoundingBox) throws TransformException {
        double d;
        GeographicCRS geographicCRS;
        CoordinateReferenceSystem coordinateReferenceSystem = envelope.getCoordinateReferenceSystem();
        if (!(coordinateReferenceSystem == null || ProxyForMetadataImpl.startsWith(coordinateReferenceSystem, geographicCRS = CRSUtilities.getStandardGeographicCRS2D(coordinateReferenceSystem)) || ProxyForMetadataImpl.startsWith(coordinateReferenceSystem, DefaultGeographicCRS.WGS84) || ProxyForMetadataImpl.startsWith(coordinateReferenceSystem, DefaultGeographicCRS.WGS84_3D))) {
            CoordinateOperation coordinateOperation;
            CoordinateOperationFactory coordinateOperationFactory = this.getFactory();
            try {
                coordinateOperation = coordinateOperationFactory.createOperation(coordinateReferenceSystem, geographicCRS);
            }
            catch (FactoryException factoryException) {
                throw new TransformPathNotFoundException(Errors.format(40, factoryException));
            }
            envelope = Envelopes.transform(coordinateOperation, envelope);
        }
        double d2 = envelope.getMinimum(0);
        double d3 = envelope.getMaximum(0);
        double d4 = envelope.getMinimum(1);
        if (d4 > (d = envelope.getMaximum(1))) {
            throw new IllegalArgumentException(Errors.format(81, 1));
        }
        boolean bl = true;
        if (d2 > d3) {
            if (!InternalUtilities.isPoleToPole(d4, d)) {
                throw new IllegalArgumentException(Errors.format(81, 0));
            }
            double d5 = d2;
            d2 = d3;
            d3 = d5;
            bl = false;
        }
        defaultGeographicBoundingBox.setBounds(d2, d3, d4, d);
        defaultGeographicBoundingBox.setInclusion(bl);
    }

    private static boolean startsWith(CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2) {
        int n = coordinateReferenceSystem2.getCoordinateSystem().getDimension();
        return coordinateReferenceSystem.getCoordinateSystem().getDimension() >= n && CRS.equalsIgnoreMetadata(CRS.getSubCRS(coordinateReferenceSystem, 0, n), coordinateReferenceSystem2);
    }

    @Override
    public void copy(Envelope envelope, DefaultVerticalExtent defaultVerticalExtent) throws TransformException {
        CoordinateReferenceSystem coordinateReferenceSystem = envelope.getCoordinateReferenceSystem();
        VerticalCRS verticalCRS = CRS.getVerticalCRS(coordinateReferenceSystem);
        if (verticalCRS == null && envelope.getDimension() != 1) {
            throw new TransformPathNotFoundException(Errors.format(77));
        }
        this.copy(envelope, defaultVerticalExtent, coordinateReferenceSystem, verticalCRS);
    }

    @Override
    public void copy(Envelope envelope, DefaultTemporalExtent defaultTemporalExtent) throws TransformException {
        CoordinateReferenceSystem coordinateReferenceSystem = envelope.getCoordinateReferenceSystem();
        TemporalCRS temporalCRS = CRS.getTemporalCRS(coordinateReferenceSystem);
        if (temporalCRS == null) {
            throw new TransformPathNotFoundException(Errors.format(77));
        }
        this.copy(envelope, defaultTemporalExtent, coordinateReferenceSystem, temporalCRS);
    }

    private void copy(Envelope envelope, DefaultVerticalExtent defaultVerticalExtent, CoordinateReferenceSystem coordinateReferenceSystem, VerticalCRS verticalCRS) throws TransformException {
        int n;
        int n2 = n = verticalCRS == null ? 0 : CRSUtilities.dimensionColinearWith(coordinateReferenceSystem.getCoordinateSystem(), verticalCRS.getCoordinateSystem());
        if (n >= 0) {
            defaultVerticalExtent.setMinimumValue(envelope.getMinimum(n));
            defaultVerticalExtent.setMaximumValue(envelope.getMaximum(n));
        }
        defaultVerticalExtent.setVerticalCRS(verticalCRS);
    }

    private void copy(Envelope envelope, DefaultTemporalExtent defaultTemporalExtent, CoordinateReferenceSystem coordinateReferenceSystem, TemporalCRS temporalCRS) throws TransformException {
        int n = CRSUtilities.dimensionColinearWith(coordinateReferenceSystem.getCoordinateSystem(), temporalCRS.getCoordinateSystem());
        if (n >= 0) {
            DefaultTemporalCRS defaultTemporalCRS = DefaultTemporalCRS.castOrCopy(temporalCRS);
            defaultTemporalExtent.setStartTime(defaultTemporalCRS.toDate(envelope.getMinimum(n)));
            defaultTemporalExtent.setEndTime(defaultTemporalCRS.toDate(envelope.getMaximum(n)));
        }
    }

    @Override
    public void copy(Envelope envelope, DefaultExtent defaultExtent) throws TransformException {
        Object object;
        Object object2;
        CoordinateReferenceSystem coordinateReferenceSystem = envelope.getCoordinateReferenceSystem();
        if (CRS.getHorizontalCRS(coordinateReferenceSystem) != null) {
            object2 = new DefaultGeographicBoundingBox();
            ((AbstractGeographicExtent)object2).setInclusion(Boolean.TRUE);
            this.copy(envelope, (DefaultGeographicBoundingBox)object2);
            defaultExtent.getGeographicElements().add((GeographicExtent)object2);
        }
        if ((object2 = CRS.getVerticalCRS(coordinateReferenceSystem)) != null) {
            object = new DefaultVerticalExtent();
            this.copy(envelope, (DefaultVerticalExtent)object, coordinateReferenceSystem, (VerticalCRS)object2);
            defaultExtent.getVerticalElements().add((VerticalExtent)object);
        }
        if ((object = CRS.getTemporalCRS(coordinateReferenceSystem)) != null) {
            DefaultTemporalExtent defaultTemporalExtent = new DefaultTemporalExtent();
            this.copy(envelope, defaultTemporalExtent, coordinateReferenceSystem, (TemporalCRS)object);
            defaultExtent.getTemporalElements().add(defaultTemporalExtent);
        }
    }
}

